IF (NOT UNITTEST)
	message(FATAL_ERROR "UNITTEST is not defined!")
ENDIF ()

IF (NOT UNITTEST_SRCFILES)
	SET(UNITTEST_SRCFILES main.cpp)
ENDIF ()

add_executable(${UNITTEST} ${UNITTEST_SRCFILES})

TARGET_LINK_LIBRARIES(${UNITTEST} PRIVATE restinio::restinio)
TARGET_LINK_LIBRARIES(${UNITTEST} PRIVATE Catch2::Catch2WithMain)
TARGET_INCLUDE_DIRECTORIES(${UNITTEST} PRIVATE ${CMAKE_SOURCE_DIR})

link_threads_if_necessary(${UNITTEST})

IF (WIN32)
	TARGET_LINK_LIBRARIES(${UNITTEST} PRIVATE wsock32 ws2_32)
ENDIF ()

if (MSVC)
    target_compile_options(${UNITTEST} PRIVATE /bigobj)
endif ()

catch_discover_tests(
	${UNITTEST}
	TEST_SUFFIX ${RESTINIO_TEST_SUFFIX})
