/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class TargetReference {
    private final Parameter parameter;
    private final List<PropertyEntry> propertyEntries;
    private final boolean isValid;

    private TargetReference(Parameter sourceParameter, List<PropertyEntry> sourcePropertyEntries, boolean isValid) {
        this.parameter = sourceParameter;
        this.propertyEntries = sourcePropertyEntries;
        this.isValid = isValid;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public List<PropertyEntry> getPropertyEntries() {
        return this.propertyEntries;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<String> getElementNames() {
        ArrayList<String> elementNames = new ArrayList<String>();
        if (this.parameter != null) {
            elementNames.add(this.parameter.getName());
        }
        for (PropertyEntry propertyEntry : this.propertyEntries) {
            elementNames.add(propertyEntry.getName());
        }
        return elementNames;
    }

    public TargetReference pop() {
        if (this.propertyEntries.size() > 1) {
            ArrayList<PropertyEntry> newPropertyEntries = new ArrayList<PropertyEntry>(this.propertyEntries.size() - 1);
            for (PropertyEntry propertyEntry : this.propertyEntries) {
                PropertyEntry newPropertyEntry = propertyEntry.pop();
                if (newPropertyEntry == null) continue;
                newPropertyEntries.add(newPropertyEntry);
            }
            return new TargetReference(null, newPropertyEntries, this.isValid);
        }
        return null;
    }

    private static class NoPropertyErrorMessage
    extends MappingErrorMessage {
        private final String[] entryNames;
        private final int index;
        private final Type nextType;

        private NoPropertyErrorMessage(Mapping mapping, SourceMethod method, FormattingMessager messager, String[] entryNames, int index, Type nextType) {
            super(mapping, method, messager);
            this.entryNames = entryNames;
            this.index = index;
            this.nextType = nextType;
        }

        @Override
        public void report() {
            Set<String> readAccessors = this.nextType.getPropertyReadAccessors().keySet();
            String mostSimilarProperty = Strings.getMostSimilarWord(this.entryNames[this.index], readAccessors);
            ArrayList<String> elements = new ArrayList<String>(Arrays.asList(this.entryNames).subList(0, this.index));
            elements.add(mostSimilarProperty);
            this.printErrorMessage(Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_RESULTTYPE, Strings.join(elements, "."));
        }
    }

    private static class NoWriteAccessorErrorMessage
    extends MappingErrorMessage {
        private NoWriteAccessorErrorMessage(Mapping mapping, SourceMethod method, FormattingMessager messager) {
            super(mapping, method, messager);
        }

        @Override
        public void report() {
            this.printErrorMessage(Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_RESULTTYPE, new Object[0]);
        }
    }

    private static abstract class MappingErrorMessage {
        private final Mapping mapping;
        private final SourceMethod method;
        private final FormattingMessager messager;

        private MappingErrorMessage(Mapping mapping, SourceMethod method, FormattingMessager messager) {
            this.mapping = mapping;
            this.method = method;
            this.messager = messager;
        }

        abstract void report();

        protected void printErrorMessage(Message message, Object ... args) {
            Object[] errorArgs = new Object[args.length + 2];
            errorArgs[0] = this.mapping.getTargetName();
            errorArgs[1] = this.method.getResultType();
            System.arraycopy(args, 0, errorArgs, 2, args.length);
            AnnotationMirror annotationMirror = this.mapping.getMirror();
            this.messager.printMessage((Element)this.method.getExecutable(), annotationMirror, this.mapping.getSourceAnnotationValue(), message, errorArgs);
        }
    }

    public static class BuilderFromTargetMapping {
        private Mapping mapping;
        private SourceMethod method;
        private FormattingMessager messager;
        private TypeFactory typeFactory;
        private AccessorNamingUtils accessorNaming;
        private boolean isReverse;
        private Parameter reverseSourceParameter;
        private MappingErrorMessage errorMessage;

        public BuilderFromTargetMapping messager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public BuilderFromTargetMapping mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public BuilderFromTargetMapping method(SourceMethod method) {
            this.method = method;
            return this;
        }

        public BuilderFromTargetMapping typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public BuilderFromTargetMapping accessorNaming(AccessorNamingUtils accessorNaming) {
            this.accessorNaming = accessorNaming;
            return this;
        }

        public BuilderFromTargetMapping isReverse(boolean isReverse) {
            this.isReverse = isReverse;
            return this;
        }

        public BuilderFromTargetMapping reverseSourceParameter(Parameter reverseSourceParameter) {
            this.reverseSourceParameter = reverseSourceParameter;
            return this;
        }

        public TargetReference build() {
            boolean foundEntryMatch;
            String[] targetPropertyNames;
            String targetName = this.mapping.getTargetName();
            if (targetName == null) {
                return null;
            }
            String targetNameTrimmed = targetName.trim();
            if (!targetName.equals(targetNameTrimmed)) {
                this.messager.printMessage((Element)this.method.getExecutable(), this.mapping.getMirror(), this.mapping.getTargetAnnotationValue(), Message.PROPERTYMAPPING_WHITESPACE_TRIMMED, targetName, targetNameTrimmed);
            }
            String[] segments = targetNameTrimmed.split("\\.");
            Parameter parameter = this.method.getMappingTargetParameter();
            Type resultType = this.method.getResultType();
            List<PropertyEntry> entries = this.getTargetEntries(resultType = this.typeBasedOnMethod(resultType), targetPropertyNames = segments);
            boolean bl = foundEntryMatch = entries.size() == targetPropertyNames.length;
            if (!foundEntryMatch && segments.length > 1 && BuilderFromTargetMapping.matchesSourceOrTargetParameter(segments[0], parameter, this.reverseSourceParameter, this.isReverse)) {
                targetPropertyNames = Arrays.copyOfRange(segments, 1, segments.length);
                entries = this.getTargetEntries(resultType, targetPropertyNames);
                boolean bl2 = foundEntryMatch = entries.size() == targetPropertyNames.length;
            }
            if (!foundEntryMatch && this.errorMessage != null && !this.isReverse) {
                this.errorMessage.report();
            }
            return new TargetReference(parameter, entries, foundEntryMatch);
        }

        private List<PropertyEntry> getTargetEntries(Type type, String[] entryNames) {
            CollectionMappingStrategyPrism cms = this.method.getMapperConfiguration().getCollectionMappingStrategy();
            ArrayList<PropertyEntry> targetEntries = new ArrayList<PropertyEntry>();
            Type nextType = type;
            for (int i = 0; i < entryNames.length; ++i) {
                boolean isNotLast;
                Type mappingType = this.typeBasedOnMethod(nextType);
                Accessor targetReadAccessor = mappingType.getPropertyReadAccessors().get(entryNames[i]);
                Accessor targetWriteAccessor = mappingType.getPropertyWriteAccessors(cms).get(entryNames[i]);
                boolean isLast = i == entryNames.length - 1;
                boolean bl = isNotLast = i < entryNames.length - 1;
                if (BuilderFromTargetMapping.isWriteAccessorNotValidWhenNotLast(targetWriteAccessor, isNotLast) || BuilderFromTargetMapping.isWriteAccessorNotValidWhenLast(targetWriteAccessor, targetReadAccessor, this.mapping, isLast)) {
                    this.setErrorMessage(targetWriteAccessor, targetReadAccessor, entryNames, i, nextType);
                    break;
                }
                if (!isLast && !this.accessorNaming.isSetterMethod(targetWriteAccessor) && !Executables.isFieldAccessor(targetWriteAccessor)) continue;
                nextType = this.findNextType(nextType, targetWriteAccessor, targetReadAccessor);
                String[] fullName = Arrays.copyOfRange(entryNames, 0, i + 1);
                PropertyEntry propertyEntry = PropertyEntry.forTargetReference(fullName, targetReadAccessor, targetWriteAccessor, nextType);
                targetEntries.add(propertyEntry);
            }
            return targetEntries;
        }

        private Type findNextType(Type initial, Accessor targetWriteAccessor, Accessor targetReadAccessor) {
            Accessor toUse = targetWriteAccessor != null ? targetWriteAccessor : targetReadAccessor;
            Type nextType = this.accessorNaming.isGetterMethod(toUse) || Executables.isFieldAccessor(toUse) ? this.typeFactory.getReturnType((DeclaredType)this.typeBasedOnMethod(initial).getTypeMirror(), toUse) : this.typeFactory.getSingleParameter((DeclaredType)this.typeBasedOnMethod(initial).getTypeMirror(), toUse).getType();
            return nextType;
        }

        private void setErrorMessage(Accessor targetWriteAccessor, Accessor targetReadAccessor, String[] entryNames, int index, Type nextType) {
            this.errorMessage = targetWriteAccessor == null && targetReadAccessor == null ? new NoPropertyErrorMessage(this.mapping, this.method, this.messager, entryNames, index, nextType) : (targetWriteAccessor == null ? new NoWriteAccessorErrorMessage(this.mapping, this.method, this.messager) : new NoPropertyErrorMessage(this.mapping, this.method, this.messager, entryNames, index, nextType));
        }

        private Type typeBasedOnMethod(Type type) {
            if (this.method.isUpdateMethod()) {
                return type;
            }
            return type.getEffectiveType();
        }

        private static boolean isWriteAccessorNotValidWhenNotLast(Accessor accessor, boolean isNotLast) {
            return accessor == null && isNotLast;
        }

        private static boolean isWriteAccessorNotValidWhenLast(Accessor writeAccessor, Accessor readAccessor, Mapping mapping, boolean isLast) {
            return writeAccessor == null && isLast && (readAccessor == null || !mapping.isIgnored());
        }

        private static boolean matchesSourceOrTargetParameter(String segment, Parameter targetParameter, Parameter reverseSourceParameter, boolean isReverse) {
            boolean matchesTargetParameter = targetParameter != null && targetParameter.getName().equals(segment);
            return matchesTargetParameter || isReverse && reverseSourceParameter != null && reverseSourceParameter.getName().equals(segment);
        }
    }
}

