/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.ExecutionTemplate;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

public interface DatabaseType
extends Plugin {
    public String getName();

    public int getNullType();

    public boolean supportsReadOnlyTransactions();

    public boolean handlesJDBCUrl(String var1);

    public Pattern getJDBCCredentialsPattern();

    public String getDriverClass(String var1, ClassLoader var2);

    public String getBackupDriverClass(String var1, ClassLoader var2);

    public boolean handlesDatabaseProductNameAndVersion(String var1, String var2, Connection var3);

    public Database createDatabase(Configuration var1, boolean var2, JdbcConnectionFactory var3, StatementInterceptor var4);

    public Database createDatabase(Configuration var1, JdbcConnectionFactory var2, StatementInterceptor var3);

    public Parser createParser(Configuration var1, ResourceProvider var2, ParsingContext var3);

    public SqlScriptFactory createSqlScriptFactory(Configuration var1, ParsingContext var2);

    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory var1, CallbackExecutor var2, StatementInterceptor var3);

    public DatabaseExecutionStrategy createExecutionStrategy(Connection var1);

    public ExecutionTemplate createTransactionalExecutionTemplate(Connection var1, boolean var2);

    public void setDefaultConnectionProps(String var1, Properties var2, ClassLoader var3);

    public void setConfigConnectionProps(Configuration var1, Properties var2, ClassLoader var3);

    public void setOverridingConnectionProps(Map<String, String> var1);

    public void shutdownDatabase(String var1, Driver var2);

    public boolean detectUserRequiredByUrl(String var1);

    public boolean detectPasswordRequiredByUrl(String var1);

    public boolean externalAuthPropertiesRequired(String var1, String var2, String var3);

    public Properties getExternalAuthProperties(String var1, String var2);

    public Connection alterConnectionAsNeeded(Connection var1, Configuration var2);

    public String instantiateClassExtendedErrorMessage();

    public void printMessages();

    default public List<String> getSpecialResourceFilenames(Configuration configuration) {
        return Collections.emptyList();
    }
}

