/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.FlywayExpiredLicenseKeyException;
import org.flywaydb.core.extensibility.FlywayMissingLicenseKeyException;
import org.flywaydb.core.extensibility.FlywayTrialExpiredException;
import org.flywaydb.core.extensibility.LicenseInfo;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;

public class LicenseGuard {
    public static void guard(Configuration configuration, List<Edition> editions, String featureName) {
        try {
            LicenseInfo licenseInfo = LicenseInfo.create(configuration.getLicenseKey());
            if (!editions.contains((Object)licenseInfo.getLicenseType().getEdition())) {
                throw new FlywayEditionUpgradeRequiredException(editions.get(0), licenseInfo.getLicenseType().getEdition(), featureName);
            }
            if (licenseInfo.isExpired()) {
                if (licenseInfo.isTrial()) {
                    throw new FlywayTrialExpiredException(licenseInfo.getLicenseType().getEdition(), featureName);
                }
                throw new FlywayExpiredLicenseKeyException(licenseInfo.getLicenseType().getEdition(), featureName);
            }
        }
        catch (FlywayMissingLicenseKeyException e) {
            throw new FlywayMissingLicenseKeyException(featureName, e);
        }
    }
}

