/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.update;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.updater.AppUpdater;
import net.jami.jams.common.updater.FileDescription;
import net.jami.jams.server.Server;
import net.jami.jams.server.update.UpdateCheckTask;
import net.jami.jams.server.update.UpdateDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAMSUpdater
implements AppUpdater {
    private static final Logger log = LoggerFactory.getLogger(JAMSUpdater.class);
    protected static volatile String UPDATE_SERVER_URI;
    private static volatile Long UPDATE_INTERVAL;
    public static final AtomicBoolean updateAvailable;
    private final AtomicBoolean doUpdate;
    private final UpdateCheckTask updateCheckTask = new UpdateCheckTask();
    private final UpdateDownloader updateDownloader = new UpdateDownloader();
    private final Timer timer = new Timer();
    public static volatile X509Certificate certificate;
    public static volatile PrivateKey privateKey;
    private final Gson gson = GsonFactory.createGson();

    public JAMSUpdater(AtomicBoolean doUpdate) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("oem/config.json");
        InputStreamReader reader = new InputStreamReader(input);
        JsonObject jsonObject = this.gson.fromJson((Reader)reader, JsonObject.class);
        UPDATE_SERVER_URI = jsonObject.get("UPDATE_URL").getAsString();
        UPDATE_INTERVAL = jsonObject.get("UPDATE_INTERVAL").getAsLong();
        this.doUpdate = doUpdate;
        this.timer.schedule((TimerTask)this.updateCheckTask, 0L, (long)UPDATE_INTERVAL);
    }

    @Override
    public HashMap<String, FileDescription> getLocalVersions() {
        return this.updateCheckTask.getLocalData();
    }

    @Override
    public HashMap<String, FileDescription> getRemoteVersions() {
        return this.updateCheckTask.getRemoteData();
    }

    @Override
    public boolean getUpdateAvailable() {
        return updateAvailable.get();
    }

    @Override
    public void setLicense(X509Certificate certificate, PrivateKey privateKey) {
        JAMSUpdater.certificate = certificate;
        JAMSUpdater.privateKey = privateKey;
    }

    @Override
    public void doUpdate() {
        boolean res = this.updateDownloader.downloadFiles(this.getRemoteVersions());
        if (res) {
            Server.updateInterface.approveUpdate();
        } else {
            log.error("An error occurred while attempting to perform the update. This could be a hardware problem or a corrupt file. Try the download again.");
        }
    }

    public AtomicBoolean getDoUpdate() {
        return this.doUpdate;
    }

    public UpdateCheckTask getUpdateCheckTask() {
        return this.updateCheckTask;
    }

    public UpdateDownloader getUpdateDownloader() {
        return this.updateDownloader;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Gson getGson() {
        return this.gson;
    }

    static {
        updateAvailable = new AtomicBoolean(false);
    }
}

