/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.startup;

import java.util.Optional;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.objects.system.SystemAccount;
import net.jami.jams.common.utils.LibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoEngineLoader {
    private static final Logger log = LoggerFactory.getLogger(CryptoEngineLoader.class);

    public static CertificateAuthority loadCertificateAuthority(String config, DataStore dataStore) {
        try {
            Class<?> cls = LibraryLoader.classLoader.loadClass("net.jami.jams.ca.JamsCA");
            CertificateAuthority certificateAuthority = (CertificateAuthority)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            Optional<SystemAccount> accounts = dataStore.getSystemDao().getCA();
            if (accounts.isEmpty()) {
                log.info("This is an fresh install, and it has no CA or any system accounts - if there is a config.json file in your directory, this means the install is broken and you should delete and restart!");
            } else {
                SystemAccount caAccount = accounts.orElseThrow();
                SystemAccount ocspAccount = dataStore.getSystemDao().getOCSP().orElseThrow();
                log.info("Injecting OCSP and CA accounts...");
                certificateAuthority.init(config, caAccount, ocspAccount);
            }
            log.info("Loaded X509 Engine - please make sure it is initialized before using it to sign requests!");
            return certificateAuthority;
        }
        catch (Exception e) {
            log.error("Load X509 Engine failed with error:", e);
            return null;
        }
    }
}

