/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.image;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig
@WebServlet(value={"/api/image/filehandler/*"})
public class FileHandlerServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(FileHandlerServlet.class);
    private static final String IMAGES_DIR = "images";
    private static final String SAVE_DIR = "../../../../../images";

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || pathInfo.equals("/")) {
                response.sendError(400);
                return;
            }
            String[] pathParts = pathInfo.split("/");
            if (pathParts.length != 3) {
                response.sendError(400);
                return;
            }
            String blueprintName = pathParts[1];
            String imageType = pathParts[2];
            File imagesFolder = new File(IMAGES_DIR + File.separator + blueprintName);
            if (!imagesFolder.exists()) {
                imagesFolder.mkdirs();
                Paths.get(IMAGES_DIR, blueprintName, "logo").toFile().mkdirs();
                Paths.get(IMAGES_DIR, blueprintName, "background").toFile().mkdirs();
            }
            Part filePart = request.getPart("file");
            Object fileName = filePart.getSubmittedFileName();
            String ext = ((String)fileName).substring(((String)fileName).lastIndexOf(".") + 1);
            for (Part part : request.getParts()) {
                long now = System.currentTimeMillis();
                fileName = now + "." + ext;
                Path path = Paths.get(SAVE_DIR, new String[]{blueprintName, imageType, fileName});
                part.write(path.toString());
            }
            HashMap<String, CallSite> map = new HashMap<String, CallSite>();
            String url = "/api/image/filehandler/" + blueprintName + "/" + imageType + "/" + (String)fileName;
            map.put("url", (CallSite)((Object)url));
            Gson gson = GsonFactory.createGson();
            response.setStatus(200);
            response.getWriter().write(gson.toJson(map));
        }
        catch (Exception e) {
            log.error("Error during file upload: " + e.getMessage());
            response.setStatus(500);
            response.getWriter().write("Error during file upload: " + e.getMessage());
        }
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null || pathInfo.equals("/")) {
                response.sendError(400);
                return;
            }
            String[] pathParts = pathInfo.split("/");
            if (pathParts.length != 4) {
                response.sendError(400);
                return;
            }
            String blueprintName = pathParts[1];
            String imageType = pathParts[2];
            String fileName = pathParts[3];
            Path imageFilePath = Paths.get(IMAGES_DIR, blueprintName, imageType, fileName);
            if (!imageFilePath.toFile().exists()) {
                response.sendError(404);
                return;
            }
            byte[] imageData = Files.readAllBytes(imageFilePath);
            String mimeType = Files.probeContentType(imageFilePath);
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            response.setContentType(mimeType);
            response.setHeader("Cache-Control", "public, max-age=31536000");
            try (ServletOutputStream out = response.getOutputStream();){
                out.write(imageData);
            }
        }
        catch (IOException e) {
            log.error("FileHandlerServlet: Error while processing request", e);
            response.sendError(500);
        }
    }
}

