/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.device;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/devices"})
public class DevicesServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        List<Device> devices = Server.dataStore.getDeviceDao().getByOwner(username);
        if (Server.certificateAuthority.getLatestCRL() != null) {
            devices.forEach(device -> device.setRevoked(Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(device.getCertificate().getSerialNumber()) != null));
        } else {
            devices.forEach(device -> device.setRevoked(false));
        }
        resp.getOutputStream().write(this.gson.toJson(devices).getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }
}

