/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.device;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.DeviceRegistrationRequest;
import net.jami.jams.common.objects.responses.DeviceRegistrationResponse;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.RegisterDeviceFlow;
import net.jami.jams.server.core.workflows.RevokeDeviceFlow;

@WebServlet(value={"/api/auth/device/*"})
public class DeviceServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        String deviceId = req.getPathInfo().replace("/", "");
        Device device = Server.dataStore.getDeviceDao().getByDeviceIdAndOwner(deviceId, username).orElseThrow();
        if (Server.certificateAuthority.getLatestCRL().get() != null) {
            device.setRevoked(Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(device.getCertificate().getSerialNumber()) != null);
        } else {
            device.setRevoked(false);
        }
        resp.getOutputStream().write(this.gson.toJson(device).getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        DeviceRegistrationRequest request;
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        Gson gson = GsonFactory.createGson();
        String username = req.getAttribute("username").toString();
        DeviceRegistrationResponse devResponse = RegisterDeviceFlow.registerDevice(username, request = gson.fromJson((Reader)req.getReader(), DeviceRegistrationRequest.class));
        if (devResponse == null) {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "A server error occurred while enrolling the device.");
            return;
        }
        String filteredJson = gson.toJson(devResponse);
        JsonObject obj = gson.fromJson(filteredJson, JsonObject.class);
        DeviceServlet.renameKeys(obj);
        resp.getOutputStream().write(obj.toString().getBytes());
        resp.flushBuffer();
    }

    private static void renameKey(JsonObject obj, String oldKey, String newKey) {
        if (obj.get(oldKey) != null) {
            obj.add(newKey, obj.get(oldKey));
            obj.remove(oldKey);
        }
    }

    public static void renameKeys(JsonObject obj) {
        DeviceServlet.renameKey(obj, "videoEnabled", "Account.videoEnabled");
        DeviceServlet.renameKey(obj, "publicInCalls", "DHTRelay.PublicInCalls");
        DeviceServlet.renameKey(obj, "autoAnswer", "Account.autoAnswer");
        DeviceServlet.renameKey(obj, "peerDiscovery", "Account.peerDiscovery");
        DeviceServlet.renameKey(obj, "accountDiscovery", "Account.accountDiscovery");
        DeviceServlet.renameKey(obj, "accountPublish", "Account.accountPublish");
        DeviceServlet.renameKey(obj, "rendezVous", "Account.rendezVous");
        DeviceServlet.renameKey(obj, "upnpEnabled", "Account.upnpEnabled");
        DeviceServlet.renameKey(obj, "turnEnabled", "TURN.enable");
        DeviceServlet.renameKey(obj, "turnServer", "TURN.server");
        DeviceServlet.renameKey(obj, "turnServerUserName", "TURN.username");
        DeviceServlet.renameKey(obj, "turnServerPassword", "TURN.password");
        DeviceServlet.renameKey(obj, "proxyEnabled", "Account.proxyEnabled");
        DeviceServlet.renameKey(obj, "proxyServer", "Account.proxyServer");
        DeviceServlet.renameKey(obj, "dhtProxyListUrl", "Account.dhtProxyListUrl");
        DeviceServlet.renameKey(obj, "displayName", "Account.displayName");
        DeviceServlet.renameKey(obj, "defaultModerators", "Account.defaultModerators");
        DeviceServlet.renameKey(obj, "uiCustomization", "Account.uiCustomization");
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        String deviceId = req.getPathInfo().replace("/", "");
        String deviceName = req.getParameter("deviceName");
        if (Server.dataStore.getDeviceDao().updateObject(deviceName, username, deviceId)) {
            resp.setStatus(200);
        } else {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "A server error occurred while updating the device information.");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String deviceId = req.getPathInfo().replace("/", "");
        String owner = req.getAttribute("username").toString();
        long deviceIdCount = Server.dataStore.getDeviceDao().getByOwner(owner).stream().filter(device -> device.getDeviceId().equals(deviceId)).count();
        if (deviceIdCount == 0L) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient rights to revoke this device!");
            return;
        }
        DeviceRevocationResponse devResponse = RevokeDeviceFlow.revokeDevice(owner, deviceId);
        if (devResponse != null) {
            resp.getOutputStream().write(this.gson.toJson(devResponse).getBytes());
            resp.flushBuffer();
        } else {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "A server error occurred while revoking the device.");
        }
    }
}

