/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.contacts;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.jami.jams.common.objects.contacts.Contact;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.common.utils.ContactMerger;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/contacts"})
public class ContactServlet
extends HttpServlet {
    private static final Gson gson = GsonFactory.createGson();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        List<Contact> contactList = Server.dataStore.getContactDao().getByOwner(username);
        resp.getOutputStream().write(gson.toJson(contactList).getBytes());
        resp.flushBuffer();
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String owner = req.getAttribute("username").toString();
        ContactServlet.addContact(req, resp, owner);
    }

    public static void addContact(HttpServletRequest req, HttpServletResponse resp, String owner) throws IOException {
        JsonObject obj = gson.fromJson((Reader)req.getReader(), JsonObject.class);
        Contact contact = new Contact();
        contact.setDisplayName(obj.get("displayName").toString());
        contact.setAdded(System.currentTimeMillis() / 1000L);
        contact.setRemoved(0L);
        contact.setOwner(owner);
        contact.setUri(obj.get("uri").getAsString());
        List<Contact> localList = Server.dataStore.getContactDao().getByOwner(owner);
        List<Contact> remoteList = List.of(contact);
        List<Contact> result = ContactMerger.mergeContacts(localList, remoteList);
        if (Server.dataStore.getContactDao().storeContactList(result)) {
            resp.setStatus(200);
        } else {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "A server error occurred while storing the contact.");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String owner = req.getAttribute("username").toString();
        String uri = req.getParameter("uri");
        if (Server.dataStore.getContactDao().removeContact(owner, uri)) {
            resp.setStatus(200);
        } else {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "A server error occurred while deleting the contact.");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String owner = req.getAttribute("username").toString();
        ContactServlet.addContacts(req, resp, owner);
    }

    public static void addContacts(HttpServletRequest req, HttpServletResponse resp, String owner) throws IOException {
        List<Contact> localList = Server.dataStore.getContactDao().getByOwner(owner);
        List<Contact> remoteList = Arrays.asList(gson.fromJson((Reader)req.getReader(), Contact[].class));
        remoteList.forEach(contact -> contact.setOwner(owner));
        List<Contact> result = ContactMerger.mergeContacts(localList, remoteList);
        if (result.size() > 0 && !Server.dataStore.getContactDao().storeContactList(result)) {
            TomcatCustomErrorHandler.sendCustomError(resp, 500, "An error occurred while attempting to store contacts.");
        } else {
            resp.getOutputStream().write(gson.toJson(result).getBytes());
            resp.flushBuffer();
        }
    }
}

