/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.users;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.jami.jams.authmodule.PasswordUtil;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.RevokeDeviceFlow;
import net.jami.jams.server.core.workflows.RevokeUserFlow;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CRLEntryHolder;
import org.bouncycastle.cert.X509CRLHolder;

@WebServlet(value={"/api/admin/user"})
public class UserServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        Optional<User> result = Server.dataStore.getUserDao().getByUsername(username);
        if (result.isEmpty()) {
            resp.sendError(404, "An error occurred while attempting to obtain user.");
        }
        User user = result.get();
        X509CRLHolder crl = Server.certificateAuthority.getLatestCRL().get();
        if (crl != null) {
            X509CRLEntryHolder revoked = crl.getRevokedCertificate(user.getCertificate().getSerialNumber());
            user.setRevoked(revoked != null);
        } else {
            user.setRevoked(false);
        }
        if (!user.getNeedsPasswordReset().booleanValue() && req.getParameter("needPW") != null) {
            String pw = req.getParameter("password");
            if (pw == null || pw.isEmpty()) {
                resp.sendError(400, "Password is empty!");
                return;
            }
            String password = PasswordUtil.hashPassword(pw, Base64.decodeBase64(user.getSalt()));
            Server.dataStore.getUserDao().updateObject(password, username);
            user = Server.dataStore.getUserDao().getByUsername(username).orElseThrow();
        }
        resp.getOutputStream().write(this.gson.toJson(user).getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        JsonObject obj = this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
        String username = obj.get("username").getAsString();
        String password = obj.get("password").getAsString();
        if (password.isEmpty()) {
            resp.sendError(400, "Password is empty!");
            return;
        }
        byte[] salt = PasswordUtil.generateSalt();
        String hashedPassword = PasswordUtil.hashPassword(password, salt);
        User user = new User();
        user.setUsername(username);
        user.setNeedsPasswordReset(true);
        user.setPassword(hashedPassword);
        user.setSalt(Base64.encodeBase64String(salt));
        user.setRealm("LOCAL");
        user.setUserType(AuthenticationSourceType.LOCAL);
        if (Server.userAuthenticationModule.createUser(user.getUserType(), user.getRealm(), Server.nameServer, user)) {
            resp.setStatus(201);
            return;
        }
        resp.sendError(500, "An error occurred while attempting to create the user.");
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        JsonObject obj = this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
        String username = obj.get("username").getAsString();
        String pw = obj.get("password").getAsString();
        Optional<User> result = Server.dataStore.getUserDao().getByUsername(username);
        if (result.isEmpty()) {
            resp.sendError(404, "User was not found!");
            return;
        }
        User user = result.get();
        if (user.getUserType() != AuthenticationSourceType.LOCAL) {
            resp.sendError(500, "Unable to change user data as user is not a local user.");
            return;
        }
        byte[] salt = PasswordUtil.generateSalt();
        String password = PasswordUtil.hashPassword(pw, salt);
        String encodedSalt = Base64.encodeBase64String(salt);
        if (Server.dataStore.getUserDao().updateObject(password, encodedSalt, username)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while attempting to update the user's data field.");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        AtomicReference<DeviceRevocationResponse> devResponse = new AtomicReference<DeviceRevocationResponse>(RevokeUserFlow.revokeUser(username));
        List<Device> devices = Server.dataStore.getDeviceDao().getByOwner(username);
        if (Server.certificateAuthority.getLatestCRL() != null) {
            devices.forEach(device -> {
                if (Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(device.getCertificate().getSerialNumber()) == null) {
                    devResponse.set(RevokeDeviceFlow.revokeDevice(username, device.getDeviceId()));
                }
            });
        }
        if (devResponse.get() != null && devResponse.get().isSuccess()) {
            resp.getOutputStream().write(this.gson.toJson(devResponse.get()).getBytes());
            resp.flushBuffer();
        } else {
            resp.sendError(500, "An error occurred while revoking the user.");
        }
    }
}

