/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.update;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.responses.SubscriptionStatusResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.licensing.LicenseService;

@WebServlet(value={"/api/admin/subscription"})
public class SubscriptionServlet
extends HttpServlet {
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        SubscriptionStatusResponse subscriptionStatusResponse = new SubscriptionStatusResponse();
        subscriptionStatusResponse.setLicenseInformation(Server.licenseService.getLicenseInformation());
        subscriptionStatusResponse.setActivated(Server.activated.get());
        resp.getOutputStream().write(this.gson.toJson(subscriptionStatusResponse).getBytes());
        resp.flushBuffer();
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        JsonObject jsonObject = this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
        String license = jsonObject.get("base64License").getAsString();
        FileWriter fw = new FileWriter("license.dat");
        fw.write(license);
        fw.close();
        LicenseService licenseService = new LicenseService();
        licenseService.loadLicense();
        if (Server.activated.get()) {
            resp.setStatus(200);
        }
    }
}

