/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group"})
public class AddGroupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AddGroupServlet.class);

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        Group group = new Group();
        UUID uuid = UUID.randomUUID();
        group.setId(uuid.toString());
        JsonObject body = JsonParser.parseReader(req.getReader()).getAsJsonObject();
        group.setName(body.get("name").getAsString());
        group.setBlueprint(body.get("blueprintName").getAsString());
        if (Server.dataStore.getGroupDao().storeObject(group)) {
            JsonObject data = new JsonObject();
            data.addProperty("id", uuid.toString());
            resp.getOutputStream().write(data.toString().getBytes());
            resp.flushBuffer();
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while attempting to create the group.");
        }
    }
}

