/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Optional;
import net.jami.jams.authmodule.UserAuthenticationModule;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.DeviceRegistrationRequest;
import net.jami.jams.common.objects.responses.DeviceRegistrationResponse;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.dht.DeviceReceiptGenerator;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterDeviceFlow {
    private static final Logger log = LoggerFactory.getLogger(RegisterDeviceFlow.class);

    public static DeviceRegistrationResponse registerDevice(String username, DeviceRegistrationRequest registrationRequest) {
        try {
            User user = Server.dataStore.getUserDao().getByUsername(username).orElseThrow();
            UserProfile userProfile = Server.userAuthenticationModule.getAuthSources().get(new AuthModuleKey(user.getRealm(), user.getUserType())).searchUserProfiles(username, "LOGON_NAME", Optional.empty()).get(0);
            if (!user.getCertificate().getNotAfter().after(new Date())) {
                user = UserAuthenticationModule.certificateAuthority.getRefreshedCertificate(user);
                UserAuthenticationModule.datastore.updateUserCertificate(user);
            }
            Device device = new Device();
            device.setCertificationRequest(registrationRequest.getCsr());
            device.setOwner(username);
            device.setDisplayName(registrationRequest.getDeviceName());
            device = Server.certificateAuthority.getSignedCertificate(user, device);
            if (device == null) {
                log.error("An error occurred while creating the device certificate.");
                return null;
            }
            device.setDeviceId(DeviceReceiptGenerator.generateDeviceId(device));
            Server.dataStore.getDeviceDao().storeObject(device);
            DeviceRegistrationResponse response = new DeviceRegistrationResponse();
            String policyData = RegisterDeviceFlow.getPolicyData(username);
            if (policyData != null) {
                response.setPolicyData(policyData);
            }
            String[] devReceipt = DeviceReceiptGenerator.generateReceipt(user.getPrivateKey(), user.getCertificate().getPublicKey(), device.getCertificate().getPublicKey(), user.getEthAddress());
            response.setDeviceReceipt(devReceipt[0]);
            response.setReceiptSignature(devReceipt[1]);
            response.setDisplayName(userProfile.getFirstName() + " " + userProfile.getLastName());
            response.setNameServer(Server.nameServer.getURI());
            if (userProfile.getProfilePicture() != null) {
                response.setUserPhoto(userProfile.getProfilePicture());
            }
            response.setCertificateChain(new X509Certificate[]{Server.certificateAuthority.getCA(), user.getCertificate(), device.getCertificate()});
            return response;
        }
        catch (Exception e) {
            log.error("An error occurred while enrolling the device.");
            e.printStackTrace();
            return null;
        }
    }

    public static String getPolicyData(String username) {
        String policy = Server.dataStore.getPolicyDao().getByUsername(username).map(p -> p.getPolicyData()).orElse(null);
        if (policy == null) {
            log.warn("No policy available for user - not adding a policy component to response");
        }
        return policy;
    }
}

