/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.nameserver;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.HttpURLConnection;
import java.net.URL;
import net.jami.jams.common.jami.NameLookupResponse;
import net.jami.jams.common.jami.NameRegistrationRequest;
import net.jami.jams.common.jami.NameServer;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicNameServer
implements NameServer {
    private static final Logger log = LoggerFactory.getLogger(PublicNameServer.class);
    private final String nameserverURI;
    private final Gson gson = GsonFactory.createGson();

    public PublicNameServer(String nameserverURI) {
        this.nameserverURI = nameserverURI;
    }

    @Override
    public Integer registerName(String username, NameRegistrationRequest nameRegistrationRequest) {
        try {
            URL url = new URL(this.nameserverURI + "/name/" + username);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.getOutputStream().write(this.gson.toJson(nameRegistrationRequest).getBytes());
            con.getOutputStream().close();
            return con.getResponseCode();
        }
        catch (Exception e) {
            return 500;
        }
    }

    @Override
    public NameLookupResponse getAddressFromName(String username) {
        try {
            URL url = new URL(this.nameserverURI + "/name/" + username);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (con.getResponseCode() == 200) {
                StringBuilder responseData = new StringBuilder();
                int respSize = Integer.parseInt(con.getHeaderField("Content-Length"));
                for (int currentSize = 0; currentSize < respSize; ++currentSize) {
                    responseData.append((char)con.getInputStream().read());
                }
                log.info("Response received from public nameserver {} ", (Object)responseData);
                return this.gson.fromJson(responseData.toString(), NameLookupResponse.class);
            }
            return null;
        }
        catch (Exception e) {
            log.info("An error occurred while querying the public nameserver {} ", (Object)e.toString());
            return null;
        }
    }

    @Override
    public String getNameFromAddress(String address) {
        try {
            URL url = new URL(this.nameserverURI + "/addr/" + address);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (con.getResponseCode() != 200) {
                return null;
            }
            String responseData = new String(con.getInputStream().readAllBytes());
            log.info("Response received from public nameserver {} ", (Object)responseData);
            JsonObject json = this.gson.fromJson(responseData.toString(), JsonObject.class);
            return json.get("name").getAsString();
        }
        catch (Exception e) {
            log.info("An error occurred while querying the public nameserver {} ", (Object)e.toString());
            return null;
        }
    }

    @Override
    public String getURI() {
        return this.nameserverURI;
    }
}

