/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.dht.hashutils;

import net.jami.jams.dht.hashutils.Digest;
import net.jami.jams.dht.hashutils.MDHelper;

abstract class SHA2Core
extends MDHelper {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int[] currentVal;
    private int[] W;

    SHA2Core() {
        super(false, 8);
    }

    protected Digest copyState(SHA2Core dst) {
        System.arraycopy(this.currentVal, 0, dst.currentVal, 0, this.currentVal.length);
        return super.copyState(dst);
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        System.arraycopy(this.getInitVal(), 0, this.currentVal, 0, 8);
    }

    abstract int[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.makeMDPadding();
        int olen = this.getDigestLength();
        int i = 0;
        for (int j = 0; j < olen; j += 4) {
            SHA2Core.encodeBEInt(this.currentVal[i], output, outputOffset + j);
            ++i;
        }
    }

    @Override
    protected void doInit() {
        this.currentVal = new int[8];
        this.W = new int[64];
        this.engineReset();
    }

    private static final void encodeBEInt(int val2, byte[] buf, int off) {
        buf[off] = (byte)(val2 >>> 24);
        buf[off + 1] = (byte)(val2 >>> 16);
        buf[off + 2] = (byte)(val2 >>> 8);
        buf[off + 3] = (byte)val2;
    }

    private static final int decodeBEInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    private static int circularLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        int i;
        int A = this.currentVal[0];
        int B = this.currentVal[1];
        int C = this.currentVal[2];
        int D = this.currentVal[3];
        int E = this.currentVal[4];
        int F2 = this.currentVal[5];
        int G = this.currentVal[6];
        int H = this.currentVal[7];
        for (i = 0; i < 16; ++i) {
            this.W[i] = SHA2Core.decodeBEInt(data, 4 * i);
        }
        for (i = 16; i < 64; ++i) {
            this.W[i] = (SHA2Core.circularLeft(this.W[i - 2], 15) ^ SHA2Core.circularLeft(this.W[i - 2], 13) ^ this.W[i - 2] >>> 10) + this.W[i - 7] + (SHA2Core.circularLeft(this.W[i - 15], 25) ^ SHA2Core.circularLeft(this.W[i - 15], 14) ^ this.W[i - 15] >>> 3) + this.W[i - 16];
        }
        for (i = 0; i < 64; ++i) {
            int T1 = H + (SHA2Core.circularLeft(E, 26) ^ SHA2Core.circularLeft(E, 21) ^ SHA2Core.circularLeft(E, 7)) + (F2 & E ^ G & ~E) + K[i] + this.W[i];
            int T2 = (SHA2Core.circularLeft(A, 30) ^ SHA2Core.circularLeft(A, 19) ^ SHA2Core.circularLeft(A, 10)) + (A & B ^ A & C ^ B & C);
            H = G;
            G = F2;
            F2 = E;
            E = D + T1;
            D = C;
            C = B;
            B = A;
            A = T1 + T2;
        }
        this.currentVal[0] = this.currentVal[0] + A;
        this.currentVal[1] = this.currentVal[1] + B;
        this.currentVal[2] = this.currentVal[2] + C;
        this.currentVal[3] = this.currentVal[3] + D;
        this.currentVal[4] = this.currentVal[4] + E;
        this.currentVal[5] = this.currentVal[5] + F2;
        this.currentVal[6] = this.currentVal[6] + G;
        this.currentVal[7] = this.currentVal[7] + H;
    }

    @Override
    public String toString() {
        return "SHA-" + (this.getDigestLength() << 3);
    }
}

