/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.dht;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import net.jami.jams.dht.hashutils.HexBin;
import net.jami.jams.dht.hashutils.Keccak256;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ETHAddressGenerator {
    public static String[] generateAddress() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", "BC");
        keyGen.initialize(new ECGenParameterSpec("secp256k1"));
        KeyPair pair = keyGen.generateKeyPair();
        ECPrivateKey ecpriv = (ECPrivateKey)pair.getPrivate();
        ECPublicKey ecpub = (ECPublicKey)pair.getPublic();
        String hexPubKey = ecpub.getW().getAffineX().toString(16) + ecpub.getW().getAffineY().toString(16);
        String hexPrvKey = ecpriv.getS().toString(16);
        Keccak256 keccak256 = new Keccak256();
        byte[] addressData = keccak256.digest(HexBin.decode(hexPubKey));
        Object address = Hex.encodeHexString(addressData);
        address = "0x" + ((String)address).substring(24);
        return new String[]{address, hexPrvKey};
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

