/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.utils;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import net.jami.jams.common.objects.requests.CreateCARequest;

public class Validator {
    public static boolean validateCARequests(CreateCARequest request) {
        if (request.getCertificate() == null || request.getPrivateKey() == null) {
            return true;
        }
        if (request.getCertificate().getBasicConstraints() == -1) {
            return false;
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)request.getCertificate().getPublicKey();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)request.getPrivateKey();
        return rsaPublicKey.getModulus().equals(rsaPrivateKey.getModulus()) && BigInteger.valueOf(2L).modPow(rsaPublicKey.getPublicExponent().multiply(rsaPrivateKey.getPrivateExponent()).subtract(BigInteger.ONE), rsaPublicKey.getModulus()).equals(BigInteger.ONE);
    }
}

