/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.security.cert.X509Certificate;
import net.jami.jams.common.utils.X509Utils;

public class X509CertificateAdapter
implements JsonSerializer<X509Certificate>,
JsonDeserializer<X509Certificate> {
    @Override
    public X509Certificate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return X509Utils.getCertificateFromPEMString(json.getAsString());
    }

    @Override
    public JsonElement serialize(X509Certificate src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(X509Utils.getPEMStringFromCertificate(src));
    }
}

