/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.jami.jams.common.objects.conversations.Conversation;

public class ConversationAdapter
implements JsonSerializer<Conversation>,
JsonDeserializer<Conversation> {
    @Override
    public Conversation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new Gson();
        JsonObject input = json.getAsJsonObject();
        Conversation conversation = new Conversation();
        conversation.setId(input.get("id").getAsString());
        conversation.setCreated(input.get("created").getAsLong());
        long timeRemoved = 0L;
        if (input.has("removed")) {
            timeRemoved = input.get("removed").getAsLong();
        }
        conversation.setRemoved(timeRemoved);
        long timeErased = 0L;
        if (input.has("erased")) {
            timeErased = input.get("erased").getAsLong();
        }
        conversation.setErased(timeErased);
        if (input.has("members")) {
            conversation.setMembers(gson.toJson(input.get("members")));
        }
        conversation.setLastDisplayed(input.get("lastDisplayed").getAsString());
        return conversation;
    }

    @Override
    public JsonElement serialize(Conversation conversation, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject output = new JsonObject();
        output.addProperty("id", conversation.getId());
        output.addProperty("created", conversation.getCreated());
        output.addProperty("removed", conversation.getRemoved());
        output.addProperty("erased", conversation.getErased());
        JsonElement jsonMembers = JsonParser.parseString(conversation.getMembers());
        output.add("members", jsonMembers);
        output.addProperty("lastDisplayed", conversation.getLastDisplayed());
        return output;
    }
}

