/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.jami.jams.common.objects.contacts.Contact;

public class ContactAdapter
implements JsonSerializer<Contact>,
JsonDeserializer<Contact> {
    @Override
    public Contact deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject input = json.getAsJsonObject();
        Contact contact = new Contact();
        contact.setUri(input.get("uri").getAsString());
        contact.setConversationId(input.get("conversationId").getAsString());
        long timeAdded = 0L;
        if (input.has("added")) {
            timeAdded = input.get("added").getAsLong();
        }
        contact.setAdded(timeAdded);
        long timeRemoved = 0L;
        if (input.has("removed")) {
            timeRemoved = input.get("removed").getAsLong();
        }
        contact.setRemoved(timeRemoved);
        if (input.has("confirmed")) {
            contact.setConfirmed(input.get("confirmed").getAsBoolean());
        }
        if (input.has("banned")) {
            contact.setBanned(input.get("banned").getAsBoolean());
        }
        return contact;
    }

    @Override
    public JsonElement serialize(Contact contact, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject output = new JsonObject();
        output.addProperty("uri", contact.getUri());
        output.addProperty("conversationId", contact.getConversationId());
        output.addProperty("added", contact.getAdded());
        output.addProperty("removed", contact.getRemoved());
        if (contact.getConfirmed() != null) {
            output.addProperty("confirmed", contact.getConfirmed());
        }
        if (contact.getBanned() != null) {
            output.addProperty("banned", contact.getBanned());
        }
        return output;
    }
}

