/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.objects.contacts;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.jami.jams.common.serialization.database.DatabaseObject;

public class Contact
implements DatabaseObject {
    private transient String owner;
    private String uri;
    private String displayName;
    private Long added;
    private Long removed;
    private Boolean banned = false;
    private Boolean confirmed = false;
    private String conversationId;

    public Contact(ResultSet rs) throws Exception {
        this.owner = rs.getString("owner");
        this.uri = rs.getString("uri");
        this.displayName = rs.getString("displayName");
        this.added = rs.getLong("added");
        this.removed = rs.getLong("removed");
        this.banned = rs.getBoolean("banned");
        this.confirmed = rs.getBoolean("confirmed");
        this.conversationId = rs.getString("conversationId");
    }

    public boolean isAdded() {
        return this.added > this.removed;
    }

    @Override
    public PreparedStatement getInsert(PreparedStatement ps) throws Exception {
        ps.setString(1, this.owner);
        ps.setString(2, this.uri);
        if (this.displayName != null) {
            ps.setString(3, this.displayName);
        } else {
            ps.setString(3, "");
        }
        ps.setLong(4, this.added);
        ps.setLong(5, this.removed);
        ps.setBoolean(6, this.banned);
        ps.setBoolean(7, this.confirmed);
        ps.setString(8, this.conversationId);
        return ps;
    }

    @Override
    public PreparedStatement getDelete(PreparedStatement ps) throws Exception {
        return null;
    }

    @Override
    public PreparedStatement getUpdate(PreparedStatement ps) throws Exception {
        if (this.displayName != null) {
            ps.setString(1, this.displayName);
        } else {
            ps.setString(1, "");
        }
        ps.setLong(2, this.added);
        ps.setLong(3, this.removed);
        ps.setBoolean(4, this.banned);
        ps.setBoolean(5, this.confirmed);
        ps.setString(6, this.conversationId);
        ps.setString(7, this.owner);
        ps.setString(8, this.uri);
        return ps;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getUri() {
        return this.uri;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getAdded() {
        return this.added;
    }

    public Long getRemoved() {
        return this.removed;
    }

    public Boolean getBanned() {
        return this.banned;
    }

    public Boolean getConfirmed() {
        return this.confirmed;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setAdded(Long added) {
        this.added = added;
    }

    public void setRemoved(Long removed) {
        this.removed = removed;
    }

    public void setBanned(Boolean banned) {
        this.banned = banned;
    }

    public void setConfirmed(Boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Contact() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$added = this.getAdded();
        Long other$added = other.getAdded();
        if (this$added == null ? other$added != null : !((Object)this$added).equals(other$added)) {
            return false;
        }
        Long this$removed = this.getRemoved();
        Long other$removed = other.getRemoved();
        if (this$removed == null ? other$removed != null : !((Object)this$removed).equals(other$removed)) {
            return false;
        }
        Boolean this$banned = this.getBanned();
        Boolean other$banned = other.getBanned();
        if (this$banned == null ? other$banned != null : !((Object)this$banned).equals(other$banned)) {
            return false;
        }
        Boolean this$confirmed = this.getConfirmed();
        Boolean other$confirmed = other.getConfirmed();
        if (this$confirmed == null ? other$confirmed != null : !((Object)this$confirmed).equals(other$confirmed)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        return !(this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Contact;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $added = this.getAdded();
        result = result * 59 + ($added == null ? 43 : ((Object)$added).hashCode());
        Long $removed = this.getRemoved();
        result = result * 59 + ($removed == null ? 43 : ((Object)$removed).hashCode());
        Boolean $banned = this.getBanned();
        result = result * 59 + ($banned == null ? 43 : ((Object)$banned).hashCode());
        Boolean $confirmed = this.getConfirmed();
        result = result * 59 + ($confirmed == null ? 43 : ((Object)$confirmed).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        return result;
    }
}

