/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.annotations;

import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.annotations.PackageScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedServletAnnotationScanner {
    private static final Logger log = LoggerFactory.getLogger(ScopedServletAnnotationScanner.class);

    public void processClasses(String jarFile) {
        try {
            ArrayList<String> classNames = PackageScanner.getClasses(jarFile);
            classNames.parallelStream().forEach(this::processClass);
        }
        catch (Exception e) {
            log.info("An error occurred while modifying the target class: {}", (Object)e.getMessage());
        }
    }

    public void processClass(String className) {
        try {
            className = className.replace("/", ".").replace(".class", "");
            CtClass cc = ClassPool.getDefault().get(className);
            cc.defrost();
            CtMethod[] ctMethods = cc.getMethods();
            boolean classChanged = false;
            for (int i = 0; i < ctMethods.length; ++i) {
                MethodInfo minfo = ctMethods[i].getMethodInfo();
                for (AttributeInfo ai : minfo.getAttributes()) {
                    if (!ai.getClass().getName().contains("AnnotationsAttribute")) continue;
                    AnnotationsAttribute aa = (AnnotationsAttribute)ai;
                    for (Annotation a : aa.getAnnotations()) {
                        if (!a.getTypeName().equals(JsonContent.class.getName())) continue;
                        log.info("[{}] has secured method {}, modifying method\u2026 ", (Object)cc.getSimpleName(), (Object)ctMethods[i].getName());
                        String sb = "{\nresp.setContentType(\"application/json\");\n}\n";
                        ctMethods[i].insertBefore(sb);
                        classChanged = true;
                    }
                }
            }
            if (classChanged) {
                if (cc.isFrozen()) {
                    cc.defrost();
                }
                cc.toClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

