/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.csr.builders;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.ca.workers.csr.utils.CertificateSigner;
import net.jami.jams.ca.workers.csr.utils.ExtensionLibrary;
import net.jami.jams.common.objects.roots.X509Fields;
import net.jami.jams.common.objects.user.User;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserBuilder {
    private static final Logger log = LoggerFactory.getLogger(UserBuilder.class);

    public static User generateUser(User user) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            byte[] digest = MessageDigest.getInstance("SHA-1").digest(keyPair.getPublic().getEncoded());
            user.getX509Fields().setUid(Hex.encodeHexString(digest));
            user.setPrivateKey(keyPair.getPrivate());
            String dn = user.getX509Fields().getDN();
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded());
            X509Certificate certificate = UserBuilder.generateSignedCertificate(dn, JamsCA.userLifetime, publicKeyInfo);
            user.setCertificate(certificate);
            return user;
        }
        catch (Exception e) {
            log.error("An error occurred while generating user certificate: " + e);
            return null;
        }
    }

    public static User refreshUser(User user) {
        return UserBuilder.refreshUser(user, JamsCA.userLifetime);
    }

    public static User refreshUser(User user, long userLifeTime) {
        X509Fields x509 = new X509Fields();
        x509.setCommonName(user.getUsername());
        x509.setUid(user.getJamiId());
        user.setX509Fields(x509);
        try {
            String dn = user.getX509Fields().getDN();
            SubjectPublicKeyInfo publicKeyInfo = new JcaX509CertificateHolder(user.getCertificate()).getSubjectPublicKeyInfo();
            X509Certificate certificate = UserBuilder.generateSignedCertificate(dn, userLifeTime, publicKeyInfo);
            user.setCertificate(certificate);
            return user;
        }
        catch (Exception e) {
            log.error("An error occurred while refreshing user certificate: " + e);
            return null;
        }
    }

    private static X509Certificate generateSignedCertificate(String dn, long userLifeTime, SubjectPublicKeyInfo publicKeyInfo) throws CertificateEncodingException {
        long now = System.currentTimeMillis();
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(JamsCA.CA.getCertificate()).getSubject(), new BigInteger(128, new SecureRandom()), new Date(now - 43200000L), new Date(now + userLifeTime), new X500Name(dn), publicKeyInfo);
        X509Certificate certificate = CertificateSigner.signCertificate(JamsCA.CA.getPrivateKey(), builder, ExtensionLibrary.userExtensions);
        log.info("User certificate:  Not valid after: {}", (Object)certificate.getNotAfter());
        return certificate;
    }
}

