/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.csr.builders;

import java.io.FileWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.ca.workers.csr.utils.CertificateSigner;
import net.jami.jams.ca.workers.csr.utils.ExtensionLibrary;
import net.jami.jams.common.objects.system.SystemAccount;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAccountBuilder {
    private static final Logger log = LoggerFactory.getLogger(SystemAccountBuilder.class);

    public static SystemAccount generateCA(SystemAccount systemAccount) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new X500Name(systemAccount.getX509Fields().getDN()), new BigInteger(256, new SecureRandom()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + systemAccount.getX509Fields().getLifetime()), new X500Name(systemAccount.getX509Fields().getDN()), SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded()));
            X509Certificate certificate = CertificateSigner.signCertificate(keyPair.getPrivate(), builder, ExtensionLibrary.caExtensions);
            systemAccount.setPrivateKey(keyPair.getPrivate());
            systemAccount.setCertificate(certificate);
            JcaPEMWriter pemWriter = new JcaPEMWriter(new FileWriter("CA.pem"));
            pemWriter.writeObject(certificate);
            pemWriter.close();
            return systemAccount;
        }
        catch (Exception e) {
            log.error("Unable to generate the system CA: " + e);
            return null;
        }
    }

    public static SystemAccount generateOCSP(SystemAccount systemAccount) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(JamsCA.CA.getCertificate()).getSubject(), new BigInteger(256, new SecureRandom()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + systemAccount.getX509Fields().getLifetime()), new X500Name(systemAccount.getX509Fields().getDN()), SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded()));
            systemAccount.setPrivateKey(keyPair.getPrivate());
            systemAccount.setCertificate(CertificateSigner.signCertificate(JamsCA.CA.getPrivateKey(), builder, ExtensionLibrary.caExtensions));
            return systemAccount;
        }
        catch (Exception e) {
            log.error("Unable to generate the system OCSP: " + e);
            return null;
        }
    }
}

