/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import ezvcard.util.CharacterBitSet;
import ezvcard.util.ClearableStringBuilder;
import ezvcard.util.StringUtils;
import ezvcard.util.VCardFloatFormatter;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeoUri {
    public static final String CRS_WGS84 = "wgs84";
    private static final boolean[] validParameterValueCharacters;
    private static final Pattern hexPattern;
    private static final String PARAM_CRS = "crs";
    private static final String PARAM_UNCERTAINTY = "u";
    private final Double coordA;
    private final Double coordB;
    private final Double coordC;
    private final String crs;
    private final Double uncertainty;
    private final Map<String, String> parameters;

    private GeoUri(Builder builder) {
        this.coordA = builder.coordA == null ? Double.valueOf(0.0) : builder.coordA;
        this.coordB = builder.coordB == null ? Double.valueOf(0.0) : builder.coordB;
        this.coordC = builder.coordC;
        this.crs = builder.crs;
        this.uncertainty = builder.uncertainty;
        this.parameters = Collections.unmodifiableMap(builder.parameters);
    }

    public static GeoUri parse(String uri) {
        String scheme = "geo:";
        if (uri.length() < scheme.length() || !uri.substring(0, scheme.length()).equalsIgnoreCase(scheme)) {
            throw Messages.INSTANCE.getIllegalArgumentException(18, scheme);
        }
        Builder builder = new Builder(null, null);
        ClearableStringBuilder buffer = new ClearableStringBuilder();
        String paramName = null;
        boolean coordinatesDone = false;
        for (int i = scheme.length(); i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ',' && !coordinatesDone) {
                GeoUri.handleEndOfCoordinate(buffer, builder);
                continue;
            }
            if (c == ';') {
                if (coordinatesDone) {
                    GeoUri.handleEndOfParameter(buffer, paramName, builder);
                    paramName = null;
                    continue;
                }
                GeoUri.handleEndOfCoordinate(buffer, builder);
                if (builder.coordB == null) {
                    throw Messages.INSTANCE.getIllegalArgumentException(21, new Object[0]);
                }
                coordinatesDone = true;
                continue;
            }
            if (c == '=' && coordinatesDone && paramName == null) {
                paramName = buffer.getAndClear();
                continue;
            }
            buffer.append(c);
        }
        if (coordinatesDone) {
            GeoUri.handleEndOfParameter(buffer, paramName, builder);
        } else {
            GeoUri.handleEndOfCoordinate(buffer, builder);
            if (builder.coordB == null) {
                throw Messages.INSTANCE.getIllegalArgumentException(21, new Object[0]);
            }
        }
        return builder.build();
    }

    private static void handleEndOfCoordinate(ClearableStringBuilder buffer, Builder builder) {
        String s = buffer.getAndClear();
        if (builder.coordA == null) {
            try {
                builder.coordA = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.INSTANCE.getExceptionMessage(22, "A"), e);
            }
            return;
        }
        if (builder.coordB == null) {
            try {
                builder.coordB = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.INSTANCE.getExceptionMessage(22, "B"), e);
            }
            return;
        }
        if (builder.coordC == null) {
            try {
                builder.coordC = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Messages.INSTANCE.getExceptionMessage(22, "C"), e);
            }
            return;
        }
    }

    private static void addParameter(String name, String value, Builder builder) {
        value = GeoUri.decodeParameterValue(value);
        if (PARAM_CRS.equalsIgnoreCase(name)) {
            builder.crs = value;
            return;
        }
        if (PARAM_UNCERTAINTY.equalsIgnoreCase(name)) {
            try {
                builder.uncertainty = Double.valueOf(value);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        builder.parameters.put(name, value);
    }

    private static void handleEndOfParameter(ClearableStringBuilder buffer, String paramName, Builder builder) {
        String s = buffer.getAndClear();
        if (paramName == null) {
            if (s.length() > 0) {
                GeoUri.addParameter(s, "", builder);
            }
            return;
        }
        GeoUri.addParameter(paramName, s, builder);
    }

    public Double getCoordA() {
        return this.coordA;
    }

    public Double getCoordB() {
        return this.coordB;
    }

    public Double getCoordC() {
        return this.coordC;
    }

    public String getCrs() {
        return this.crs;
    }

    public Double getUncertainty() {
        return this.uncertainty;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public URI toUri() {
        return URI.create(this.toString());
    }

    public String toString() {
        return this.toString(6);
    }

    public String toString(int decimals) {
        VCardFloatFormatter formatter = new VCardFloatFormatter(decimals);
        StringBuilder sb = new StringBuilder("geo:");
        sb.append(formatter.format(this.coordA));
        sb.append(',');
        sb.append(formatter.format(this.coordB));
        if (this.coordC != null) {
            sb.append(',');
            sb.append(this.coordC);
        }
        if (this.crs != null && !this.crs.equalsIgnoreCase(CRS_WGS84)) {
            this.writeParameter(PARAM_CRS, this.crs, sb);
        }
        if (this.uncertainty != null) {
            this.writeParameter(PARAM_UNCERTAINTY, formatter.format(this.uncertainty), sb);
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            this.writeParameter(name, value, sb);
        }
        return sb.toString();
    }

    private void writeParameter(String name, String value, StringBuilder sb) {
        sb.append(';').append(name).append('=').append(GeoUri.encodeParameterValue(value));
    }

    private static String encodeParameterValue(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c < validParameterValueCharacters.length && validParameterValueCharacters[c]) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(value.length() * 2);
                sb.append(value.substring(0, i));
            }
            String hex = Integer.toString(c, 16);
            sb.append('%').append(hex);
        }
        return sb == null ? value : sb.toString();
    }

    private static String decodeParameterValue(String value) {
        Matcher m = hexPattern.matcher(value);
        StringBuffer sb = null;
        while (m.find()) {
            if (sb == null) {
                sb = new StringBuffer(value.length());
            }
            int hex = Integer.parseInt(m.group(1), 16);
            m.appendReplacement(sb, Character.toString((char)hex));
        }
        if (sb == null) {
            return value;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coordA == null ? 0 : this.coordA.hashCode());
        result = 31 * result + (this.coordB == null ? 0 : this.coordB.hashCode());
        result = 31 * result + (this.coordC == null ? 0 : this.coordC.hashCode());
        result = 31 * result + (this.crs == null ? 0 : this.crs.toLowerCase().hashCode());
        result = 31 * result + (this.parameters == null ? 0 : StringUtils.toLowerCase(this.parameters).hashCode());
        result = 31 * result + (this.uncertainty == null ? 0 : this.uncertainty.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoUri other = (GeoUri)obj;
        if (this.coordA == null ? other.coordA != null : !this.coordA.equals(other.coordA)) {
            return false;
        }
        if (this.coordB == null ? other.coordB != null : !this.coordB.equals(other.coordB)) {
            return false;
        }
        if (this.coordC == null ? other.coordC != null : !this.coordC.equals(other.coordC)) {
            return false;
        }
        if (this.crs == null ? other.crs != null : !this.crs.equalsIgnoreCase(other.crs)) {
            return false;
        }
        if (this.uncertainty == null ? other.uncertainty != null : !this.uncertainty.equals(other.uncertainty)) {
            return false;
        }
        if (this.parameters == null) {
            if (other.parameters != null) {
                return false;
            }
        } else {
            Map<String, String> otherParametersLower;
            if (other.parameters == null) {
                return false;
            }
            if (this.parameters.size() != other.parameters.size()) {
                return false;
            }
            Map<String, String> parametersLower = StringUtils.toLowerCase(this.parameters);
            if (!parametersLower.equals(otherParametersLower = StringUtils.toLowerCase(other.parameters))) {
                return false;
            }
        }
        return true;
    }

    static {
        int i;
        validParameterValueCharacters = new boolean[128];
        for (i = 48; i <= 57; ++i) {
            GeoUri.validParameterValueCharacters[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            GeoUri.validParameterValueCharacters[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            GeoUri.validParameterValueCharacters[i] = true;
        }
        String s = "!$&'()*+-.:[]_~";
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            GeoUri.validParameterValueCharacters[c] = true;
        }
        hexPattern = Pattern.compile("(?i)%([0-9a-f]{2})");
    }

    public static class Builder {
        private Double coordA;
        private Double coordB;
        private Double coordC;
        private String crs;
        private Double uncertainty;
        private Map<String, String> parameters;
        private CharacterBitSet validParamChars = new CharacterBitSet("a-zA-Z0-9-");

        public Builder(Double coordA, Double coordB) {
            this.parameters = new LinkedHashMap<String, String>(0);
            this.coordA(coordA);
            this.coordB(coordB);
        }

        public Builder(GeoUri original) {
            this.coordA(original.coordA);
            this.coordB(original.coordB);
            this.coordC = original.coordC;
            this.crs = original.crs;
            this.uncertainty = original.uncertainty;
            this.parameters = new LinkedHashMap<String, String>(original.parameters);
        }

        public Builder coordA(Double coordA) {
            this.coordA = coordA;
            return this;
        }

        public Builder coordB(Double coordB) {
            this.coordB = coordB;
            return this;
        }

        public Builder coordC(Double coordC) {
            this.coordC = coordC;
            return this;
        }

        public Builder crs(String crs) {
            if (crs != null && !this.validParamChars.containsOnly(crs)) {
                throw Messages.INSTANCE.getIllegalArgumentException(24, new Object[0]);
            }
            this.crs = crs;
            return this;
        }

        public Builder uncertainty(Double uncertainty) {
            this.uncertainty = uncertainty;
            return this;
        }

        public Builder parameter(String name, String value) {
            if (!this.validParamChars.containsOnly(name)) {
                throw Messages.INSTANCE.getIllegalArgumentException(23, new Object[0]);
            }
            if (value == null) {
                this.parameters.remove(name);
            } else {
                this.parameters.put(name, value);
            }
            return this;
        }

        public GeoUri build() {
            return new GeoUri(this);
        }
    }
}

