/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import ezvcard.VCard;
import ezvcard.io.json.JCardFormat;
import ezvcard.io.json.JCardWriter;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.VCardProperty;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonFormat
public class JCardSerializer
extends StdSerializer<VCard>
implements ContextualSerializer {
    private static final long serialVersionUID = -856795690626261178L;
    private ScribeIndex index = new ScribeIndex();
    private boolean addProdId = true;
    private boolean versionStrict = true;

    public JCardSerializer() {
        super(VCard.class);
    }

    @Override
    public void serialize(VCard value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        JCardWriter writer = new JCardWriter(gen);
        writer.setAddProdId(this.isAddProdId());
        writer.setVersionStrict(this.isVersionStrict());
        writer.setScribeIndex(this.getScribeIndex());
        writer.write(value);
    }

    public JCardSerializer createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return this;
        }
        JCardFormat annotation = property.getAnnotation(JCardFormat.class);
        if (annotation == null) {
            return this;
        }
        JCardSerializer result = new JCardSerializer();
        result.setAddProdId(annotation.addProdId());
        result.setVersionStrict(annotation.versionStrict());
        result.setScribeIndex(this.getScribeIndex());
        return result;
    }

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }
}

