/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import ezvcard.Messages;
import ezvcard.VCardDataType;
import ezvcard.io.json.JCardPrettyPrinter;
import ezvcard.io.json.JCardValue;
import ezvcard.io.json.JsonValue;
import ezvcard.parameter.VCardParameters;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JCardRawWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final boolean wrapInArray;
    private JsonGenerator generator;
    private boolean prettyPrint = false;
    private boolean open = false;
    private boolean closeGenerator = true;
    private PrettyPrinter prettyPrinter;

    public JCardRawWriter(Writer writer, boolean wrapInArray) {
        this.writer = writer;
        this.wrapInArray = wrapInArray;
    }

    public JCardRawWriter(JsonGenerator generator) {
        this.writer = null;
        this.generator = generator;
        this.closeGenerator = false;
        this.wrapInArray = false;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.prettyPrint = true;
        this.prettyPrinter = prettyPrinter;
    }

    public void writeStartVCard() throws IOException {
        if (this.generator == null) {
            this.init();
        }
        if (this.open) {
            this.writeEndVCard();
        }
        this.generator.writeStartArray();
        this.generator.writeString("vcard");
        this.generator.writeStartArray();
        this.open = true;
    }

    public void writeEndVCard() throws IOException {
        if (!this.open) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(1, new Object[0]));
        }
        this.generator.writeEndArray();
        this.generator.writeEndArray();
        this.open = false;
    }

    public void writeProperty(String propertyName, VCardDataType dataType, JCardValue value) throws IOException {
        this.writeProperty(null, propertyName, new VCardParameters(), dataType, value);
    }

    public void writeProperty(String group, String propertyName, VCardParameters parameters, VCardDataType dataType, JCardValue value) throws IOException {
        if (!this.open) {
            throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(1, new Object[0]));
        }
        this.generator.setCurrentValue(JCardPrettyPrinter.PROPERTY_VALUE);
        this.generator.writeStartArray();
        this.generator.writeString(propertyName);
        this.generator.writeStartObject();
        for (Map.Entry entry : parameters) {
            String name = ((String)entry.getKey()).toLowerCase();
            List values = entry.getValue();
            if (values.isEmpty()) continue;
            if (values.size() == 1) {
                this.generator.writeStringField(name, (String)values.get(0));
                continue;
            }
            this.generator.writeArrayFieldStart(name);
            for (String paramValue : values) {
                this.generator.writeString(paramValue);
            }
            this.generator.writeEndArray();
        }
        if (group != null) {
            this.generator.writeStringField("group", group);
        }
        this.generator.writeEndObject();
        this.generator.writeString(dataType == null ? "unknown" : dataType.getName().toLowerCase());
        if (value.getValues().isEmpty()) {
            this.generator.writeString("");
        } else {
            for (JsonValue jsonValue : value.getValues()) {
                this.writeValue(jsonValue);
            }
        }
        this.generator.writeEndArray();
        this.generator.setCurrentValue(null);
    }

    private void writeValue(JsonValue jsonValue) throws IOException {
        if (jsonValue.isNull()) {
            this.generator.writeNull();
            return;
        }
        Object val2 = jsonValue.getValue();
        if (val2 != null) {
            if (val2 instanceof Byte) {
                this.generator.writeNumber(((Byte)val2).byteValue());
            } else if (val2 instanceof Short) {
                this.generator.writeNumber((Short)val2);
            } else if (val2 instanceof Integer) {
                this.generator.writeNumber((Integer)val2);
            } else if (val2 instanceof Long) {
                this.generator.writeNumber((Long)val2);
            } else if (val2 instanceof Float) {
                this.generator.writeNumber(((Float)val2).floatValue());
            } else if (val2 instanceof Double) {
                this.generator.writeNumber((Double)val2);
            } else if (val2 instanceof Boolean) {
                this.generator.writeBoolean((Boolean)val2);
            } else {
                this.generator.writeString(val2.toString());
            }
            return;
        }
        List<JsonValue> array = jsonValue.getArray();
        if (array != null) {
            this.generator.writeStartArray();
            for (JsonValue element : array) {
                this.writeValue(element);
            }
            this.generator.writeEndArray();
            return;
        }
        Map<String, JsonValue> object = jsonValue.getObject();
        if (object != null) {
            this.generator.writeStartObject();
            for (Map.Entry<String, JsonValue> entry : object.entrySet()) {
                this.generator.writeFieldName(entry.getKey());
                this.writeValue(entry.getValue());
            }
            this.generator.writeEndObject();
            return;
        }
    }

    public void flush() throws IOException {
        if (this.generator == null) {
            return;
        }
        this.generator.flush();
    }

    public void closeJsonStream() throws IOException {
        if (this.generator == null) {
            return;
        }
        while (this.open) {
            this.writeEndVCard();
        }
        if (this.wrapInArray) {
            this.generator.writeEndArray();
        }
        if (this.closeGenerator) {
            this.generator.close();
        }
    }

    public void close() throws IOException {
        if (this.generator == null) {
            return;
        }
        this.closeJsonStream();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void init() throws IOException {
        JsonFactory factory = new JsonFactory();
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.generator = factory.createGenerator(this.writer);
        if (this.prettyPrint) {
            if (this.prettyPrinter == null) {
                this.prettyPrinter = new JCardPrettyPrinter();
            }
            this.generator.setPrettyPrinter(this.prettyPrinter);
        }
        if (this.wrapInArray) {
            this.generator.writeStartArray();
        }
    }
}

