/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit.ldap.internal.jndi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatchers;
import org.zapodot.junit.ldap.internal.jndi.ContextInterceptor;
import org.zapodot.junit.ldap.internal.jndi.ContextProxy;
import org.zapodot.junit.ldap.internal.jndi.DirContextProxy;

public class ContextProxyFactory {
    private static final String DELEGATED_CONTEXT_FIELD_NAME = "delegatedContext";
    private static final String DELEGATED_DIR_CONTEXT_FIELD_NAME = "delegatedDirContext";
    private static final String DELEGATING_DIR_CONTEXT_PREFIX = "DelegatingDirContext";
    private static final Class<? extends Context> CONTEXT_PROXY_TYPE = new ByteBuddy().subclass(Context.class).name(new NamingStrategy.PrefixingRandom("DelegatingContext").subclass(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Context.class))).method(ElementMatchers.isDeclaredBy(Context.class).and(ElementMatchers.not(ElementMatchers.named("close"))).and(ElementMatchers.not(ElementMatchers.isNative()))).intercept(MethodDelegation.toField("delegatedContext")).defineField("delegatedContext", (Type)((Object)Context.class), Visibility.PRIVATE).method(ElementMatchers.isDeclaredBy(Context.class).and(ElementMatchers.named("close"))).intercept(MethodDelegation.to(ContextInterceptor.class)).implement(new Type[]{ContextProxy.class}).intercept(FieldAccessor.ofBeanProperty()).make().load(ContextProxyFactory.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded();
    private static final Class<? extends DirContext> DIR_CONTEXT_PROXY_TYPE = new ByteBuddy().subclass(DirContext.class).name(new NamingStrategy.PrefixingRandom("DelegatingDirContext").subclass(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(DirContext.class))).method(ElementMatchers.isDeclaredBy(DirContext.class)).intercept(MethodDelegation.toField("delegatedDirContext")).defineField("delegatedDirContext", (Type)((Object)DirContext.class), Visibility.PRIVATE).implement(new Type[]{DirContextProxy.class}).intercept(FieldAccessor.ofBeanProperty()).make().load(ContextProxyFactory.class.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded();

    private ContextProxyFactory() {
    }

    public static Context asDelegatingContext(InitialDirContext initialDirContext) {
        return ContextProxyFactory.createProxy(initialDirContext);
    }

    private static Context createProxy(InitialDirContext initialDirContext) {
        try {
            Context contextDelegator = ContextProxyFactory.getDeclaredConstructor().newInstance(new Object[0]);
            ((ContextProxy)((Object)contextDelegator)).setDelegatedContext(initialDirContext);
            return contextDelegator;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor<? extends Context> getDeclaredConstructor() {
        try {
            return CONTEXT_PROXY_TYPE.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Can not find a default constructor for proxy class", e);
        }
    }

    public static DirContext asDelegatingDirContext(InitialDirContext initialDirContext) {
        try {
            DirContext dirContext = DIR_CONTEXT_PROXY_TYPE.newInstance();
            ((DirContextProxy)((Object)dirContext)).setDelegatedDirContext(initialDirContext);
            return dirContext;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Could not wrap DirContext", e);
        }
    }
}

