/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.util.Map;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.NettyConnection;
import org.ldaptive.transport.netty.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTransport
implements Transport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int numIoThreads;
    private int numMessageThreads = -1;
    private final Map<ChannelOption, Object> channelOptions;

    public ConnectionTransport() {
        this(0);
    }

    public ConnectionTransport(int ioThreads) {
        this(ioThreads, null);
    }

    public ConnectionTransport(int ioThreads, Map<ChannelOption, Object> options) {
        this.numIoThreads = ioThreads;
        this.channelOptions = options;
    }

    public ConnectionTransport(int ioThreads, int messageThreads) {
        this(ioThreads, messageThreads, null);
    }

    public ConnectionTransport(int ioThreads, int messageThreads, Map<ChannelOption, Object> options) {
        this.numIoThreads = ioThreads;
        this.numMessageThreads = messageThreads;
        this.channelOptions = options;
    }

    protected Class<? extends Channel> getSocketChannelType() {
        return NettyUtils.getDefaultSocketChannelType();
    }

    protected EventLoopGroup createEventLoopGroup(String name, int numThreads) {
        return NettyUtils.createDefaultEventLoopGroup(name, numThreads);
    }

    @Override
    public Connection create(ConnectionConfig cc) {
        if (this.numMessageThreads != -1) {
            return new NettyConnection(cc, this.getSocketChannelType(), this.createEventLoopGroup(ConnectionTransport.class.getSimpleName(), this.numIoThreads), this.createEventLoopGroup(ConnectionTransport.class.getSimpleName(), this.numMessageThreads), this.channelOptions, true);
        }
        return new NettyConnection(cc, this.getSocketChannelType(), this.createEventLoopGroup(ConnectionTransport.class.getSimpleName(), this.numIoThreads), null, this.channelOptions, true);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "numIoThreads=" + this.numIoThreads + ", " + "numMessageThreads=" + this.numMessageThreads + ", " + "channelOptions=" + this.channelOptions + "]";
    }
}

