/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.ConnectionActivator;
import org.ldaptive.pool.ConnectionPassivator;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.transport.Transport;

public class PooledConnectionFactory
extends BlockingConnectionPool
implements ConnectionFactory {
    public PooledConnectionFactory() {
        this.setDefaultConnectionFactory(new DefaultConnectionFactory());
    }

    public PooledConnectionFactory(Transport t) {
        this.setDefaultConnectionFactory(new DefaultConnectionFactory(t));
    }

    public PooledConnectionFactory(String ldapUrl) {
        this.setDefaultConnectionFactory(new DefaultConnectionFactory(ldapUrl));
    }

    public PooledConnectionFactory(String ldapUrl, Transport t) {
        this.setDefaultConnectionFactory(new DefaultConnectionFactory(ldapUrl, t));
    }

    public PooledConnectionFactory(ConnectionConfig cc) {
        this.setDefaultConnectionFactory(new DefaultConnectionFactory(cc));
    }

    public PooledConnectionFactory(ConnectionConfig cc, Transport t) {
        this.setDefaultConnectionFactory(new DefaultConnectionFactory(cc, t));
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this.getDefaultConnectionFactory().getConnectionConfig();
    }

    public void setConnectionConfig(ConnectionConfig cc) {
        this.getDefaultConnectionFactory().setConnectionConfig(cc);
    }

    public Transport getTransport() {
        return this.getDefaultConnectionFactory().getTransport();
    }

    @Override
    public void close() {
        super.close();
        this.getDefaultConnectionFactory().close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final PooledConnectionFactory object = new PooledConnectionFactory();

        protected Builder() {
        }

        public Builder config(ConnectionConfig cc) {
            this.object.setConnectionConfig(cc);
            return this;
        }

        public Builder min(int size) {
            this.object.setMinPoolSize(size);
            return this;
        }

        public Builder max(int size) {
            this.object.setMaxPoolSize(size);
            return this;
        }

        public Builder validateOnCheckIn(boolean b) {
            this.object.setValidateOnCheckIn(b);
            return this;
        }

        public Builder validateOnCheckOut(boolean b) {
            this.object.setValidateOnCheckOut(b);
            return this;
        }

        public Builder validatePeriodically(boolean b) {
            this.object.setValidatePeriodically(b);
            return this;
        }

        public Builder blockWaitTime(Duration time) {
            this.object.setBlockWaitTime(time);
            return this;
        }

        public Builder connectOnCreate(boolean connect) {
            this.object.setConnectOnCreate(connect);
            return this;
        }

        public Builder failFastInitialize(boolean failFast) {
            this.object.setFailFastInitialize(failFast);
            return this;
        }

        public Builder activator(ConnectionActivator activator) {
            this.object.setActivator(activator);
            return this;
        }

        public Builder passivator(ConnectionPassivator passivator) {
            this.object.setPassivator(passivator);
            return this;
        }

        public Builder validator(ConnectionValidator validator) {
            this.object.setValidator(validator);
            return this;
        }

        public Builder pruneStrategy(PruneStrategy strategy) {
            this.object.setPruneStrategy(strategy);
            return this;
        }

        public Builder name(String name) {
            this.object.setName(name);
            return this;
        }

        public PooledConnectionFactory build() {
            return this.object;
        }
    }
}

