/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.ServletContext;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.StringInterpreter;

public class StringInterpreterFactory {
    public static final String STRING_INTERPRETER_CLASS_NAME = StringInterpreter.class.getName();
    private static final StringInterpreter DEFAULT_INSTANCE = new DefaultStringInterpreter();

    public static StringInterpreter getStringInterpreter(ServletContext context) throws Exception {
        String className;
        StringInterpreter result = null;
        Object attribute = context.getAttribute(STRING_INTERPRETER_CLASS_NAME);
        if (attribute instanceof StringInterpreter) {
            return (StringInterpreter)attribute;
        }
        if (attribute instanceof String) {
            result = StringInterpreterFactory.createInstance(context, (String)attribute);
        }
        if (result == null && (className = context.getInitParameter(STRING_INTERPRETER_CLASS_NAME)) != null) {
            result = StringInterpreterFactory.createInstance(context, className);
        }
        if (result == null) {
            result = DEFAULT_INSTANCE;
        }
        context.setAttribute(STRING_INTERPRETER_CLASS_NAME, result);
        return result;
    }

    private static StringInterpreter createInstance(ServletContext context, String className) throws Exception {
        return (StringInterpreter)context.getClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private StringInterpreterFactory() {
    }

    public static class DefaultStringInterpreter
    implements StringInterpreter {
        @Override
        public String convertString(Class<?> c, String s2, String attrName, Class<?> propEditorClass, boolean isNamedAttribute) {
            String quoted = s2;
            if (!isNamedAttribute) {
                quoted = Generator.quote(s2);
            }
            if (propEditorClass != null) {
                String className = c.getCanonicalName();
                return "(" + className + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + className + ".class, \"" + attrName + "\", " + quoted + ", " + propEditorClass.getCanonicalName() + ".class)";
            }
            if (c == String.class) {
                return quoted;
            }
            if (c == Boolean.TYPE) {
                return JspUtil.coerceToPrimitiveBoolean(s2, isNamedAttribute);
            }
            if (c == Boolean.class) {
                return JspUtil.coerceToBoolean(s2, isNamedAttribute);
            }
            if (c == Byte.TYPE) {
                return JspUtil.coerceToPrimitiveByte(s2, isNamedAttribute);
            }
            if (c == Byte.class) {
                return JspUtil.coerceToByte(s2, isNamedAttribute);
            }
            if (c == Character.TYPE) {
                return JspUtil.coerceToChar(s2, isNamedAttribute);
            }
            if (c == Character.class) {
                return JspUtil.coerceToCharacter(s2, isNamedAttribute);
            }
            if (c == Double.TYPE) {
                return JspUtil.coerceToPrimitiveDouble(s2, isNamedAttribute);
            }
            if (c == Double.class) {
                return JspUtil.coerceToDouble(s2, isNamedAttribute);
            }
            if (c == Float.TYPE) {
                return JspUtil.coerceToPrimitiveFloat(s2, isNamedAttribute);
            }
            if (c == Float.class) {
                return JspUtil.coerceToFloat(s2, isNamedAttribute);
            }
            if (c == Integer.TYPE) {
                return JspUtil.coerceToInt(s2, isNamedAttribute);
            }
            if (c == Integer.class) {
                return JspUtil.coerceToInteger(s2, isNamedAttribute);
            }
            if (c == Short.TYPE) {
                return JspUtil.coerceToPrimitiveShort(s2, isNamedAttribute);
            }
            if (c == Short.class) {
                return JspUtil.coerceToShort(s2, isNamedAttribute);
            }
            if (c == Long.TYPE) {
                return JspUtil.coerceToPrimitiveLong(s2, isNamedAttribute);
            }
            if (c == Long.class) {
                return JspUtil.coerceToLong(s2, isNamedAttribute);
            }
            if (c == Object.class) {
                return quoted;
            }
            String result = this.coerceToOtherType(c, s2, isNamedAttribute);
            if (result != null) {
                return result;
            }
            String className = c.getCanonicalName();
            return "(" + className + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromPropertyEditorManager(" + className + ".class, \"" + attrName + "\", " + quoted + ")";
        }

        protected String coerceToOtherType(Class<?> c, String s2, boolean isNamedAttribute) {
            return null;
        }
    }
}

