/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.impl.services.cache.ReplacementPolicy;

final class CacheEntry {
    private final ReentrantLock mutex = new ReentrantLock();
    private Cacheable cacheable;
    private int keepCount;
    private Condition forRemove;
    private Condition settingIdentity = this.mutex.newCondition();
    private ReplacementPolicy.Callback callback;

    CacheEntry() {
    }

    void lock() {
        this.mutex.lock();
    }

    void waitUntilIdentityIsSet() {
        while (this.settingIdentity != null) {
            this.settingIdentity.awaitUninterruptibly();
        }
    }

    void unlock() {
        this.mutex.unlock();
    }

    void settingIdentityComplete() {
        this.settingIdentity.signalAll();
        this.settingIdentity = null;
    }

    void keep(boolean bl) {
        ++this.keepCount;
        if (bl) {
            this.callback.access();
        }
    }

    void unkeep() {
        --this.keepCount;
        if (this.forRemove != null && this.keepCount == 1) {
            this.forRemove.signal();
        }
    }

    boolean isKept() {
        return this.keepCount > 0;
    }

    void unkeepForRemove() {
        if (this.keepCount > 1) {
            this.forRemove = this.mutex.newCondition();
            while (this.keepCount > 1) {
                this.forRemove.awaitUninterruptibly();
            }
            this.forRemove = null;
        }
        --this.keepCount;
    }

    void setCacheable(Cacheable cacheable) {
        this.cacheable = cacheable;
    }

    Cacheable getCacheable() {
        return this.cacheable;
    }

    boolean isValid() {
        return this.settingIdentity == null && this.cacheable != null;
    }

    void setCallback(ReplacementPolicy.Callback callback2) {
        this.callback = callback2;
    }

    void free() {
        if (this.callback != null) {
            this.callback.free();
        }
        this.cacheable = null;
    }
}

