/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.x509;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.Req;

@WebServlet(value={"/api/ocsp/*"})
public class OCSPServlet
extends HttpServlet {
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/ocsp-response");
        byte[] content = new byte[Integer.parseInt(req.getHeader("Content-Length"))];
        try {
            for (int i = 0; i < content.length; ++i) {
                req.getInputStream().read(content);
            }
            OCSPReq ocspReq = new OCSPReq(content);
            ArrayList<BigInteger> ids = new ArrayList<BigInteger>();
            for (Req request : ocspReq.getRequestList()) {
                ids.add(request.getCertID().getSerialNumber());
            }
            String issuerId = req.getPathInfo().replace("/", "");
            if (issuerId == "") {
                OCSPResp response = JamsCA.getOCSPResponse(ocspReq, JamsCA.CA.getCertificate(), JamsCA.CA.getPrivateKey(), false);
                if (response != null) {
                    byte[] respBytes = response.getEncoded();
                    resp.getOutputStream().write(respBytes);
                    resp.flushBuffer();
                } else {
                    resp.setStatus(404);
                }
                return;
            }
            User targetUser = Server.dataStore.getUserDao().getByJamiId(issuerId).get(0);
            List<Device> devices = Server.dataStore.getDeviceDao().getByOwner(targetUser.getUsername());
            boolean deviceDoesNotExist = true;
            for (Device d : devices) {
                for (BigInteger id : ids) {
                    if (!d.getCertificate().getSerialNumber().equals(id)) continue;
                    deviceDoesNotExist = false;
                }
            }
            OCSPResp response = JamsCA.getOCSPResponse(ocspReq, targetUser.getCertificate(), targetUser.getPrivateKey(), deviceDoesNotExist);
            if (response != null) {
                byte[] respBytes = response.getEncoded();
                resp.getOutputStream().write(respBytes);
                resp.flushBuffer();
            } else {
                resp.setStatus(404);
            }
        }
        catch (Exception e) {
            resp.sendError(404, "Unable to find the requested certificate!");
        }
    }
}

