/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.policyData;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.core.workflows.RegisterDeviceFlow;
import net.jami.jams.server.servlets.api.auth.device.DeviceServlet;

@WebServlet(value={"/api/auth/policyData"})
public class PolicyDataServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        String policyData = RegisterDeviceFlow.getPolicyData(username);
        if (policyData == null) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)404, (String)"Policy Data not found for this user");
            return;
        }
        JsonObject obj = JsonParser.parseString(policyData).getAsJsonObject();
        DeviceServlet.renameKeys(obj);
        resp.getOutputStream().write(obj.toString().getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }
}

