/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.conversations;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import net.jami.jams.common.objects.conversations.Conversation;
import net.jami.jams.common.objects.conversations.ConversationRequest;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.common.utils.ConversationMerger;
import net.jami.jams.server.Server;

@WebServlet(value={"/api/auth/conversationRequests"})
public class ConversationRequestServlet
extends HttpServlet {
    private static final Gson gson = GsonFactory.createGson();

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String owner = req.getAttribute("username").toString();
        ConversationRequestServlet.addConversationRequests(req, resp, owner);
    }

    public static void addConversationRequests(HttpServletRequest req, HttpServletResponse resp, String owner) throws IOException {
        List<ConversationRequest> localList = Server.dataStore.getConversationRequestDao().getByOwner(owner);
        List<Conversation> conversationList = Server.dataStore.getConversationDao().getByOwner(owner);
        List<ConversationRequest> remoteList = Arrays.asList(gson.fromJson((Reader)req.getReader(), ConversationRequest[].class));
        remoteList.forEach(conversationRequest -> conversationRequest.setOwner(owner));
        List mergedConversationRequests = ConversationMerger.mergeConversationRequests(localList, remoteList);
        List<ConversationRequest> filteredConversationRequests = Server.dataStore.getConversationRequestDao().filterConversationRequests(mergedConversationRequests, conversationList);
        if (filteredConversationRequests.size() > 0 && !Server.dataStore.getConversationRequestDao().storeConversationRequestList(filteredConversationRequests)) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"Unable to store conversationRequests!");
        } else {
            resp.getOutputStream().write(gson.toJson(filteredConversationRequests).getBytes());
            resp.flushBuffer();
        }
    }
}

