/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.users;

import com.google.gson.Gson;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.serialization.adapters.GsonFactory;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/user/groups/*"})
public class UserGroupsServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UserGroupsServlet.class);
    private final Gson gson = GsonFactory.createGson();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getPathInfo().replace("/", "");
        List<UserGroupMapping> result = Server.dataStore.getUserGroupMappingsDao().getByUsername(username);
        resp.getOutputStream().write(this.gson.toJson(result).getBytes());
        resp.flushBuffer();
        resp.setStatus(200);
    }
}

