/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Scanner;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Policy;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.admin.group.PolicyProfileServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/policy"})
public class PolicyServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PolicyServlet.class);

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        PolicyProfileServlet.getPolicyAndSendResponse(resp, name);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        Scanner s2 = new Scanner(req.getInputStream()).useDelimiter("\\A");
        String policyData = s2.hasNext() ? s2.next() : "";
        try {
            JsonParser.parseString(policyData);
        }
        catch (JsonSyntaxException e) {
            resp.sendError(400, "Invalid JSON.");
            return;
        }
        if (Server.dataStore.getPolicyDao().updateObject(name, policyData)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while attempting to update the group name.");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        Scanner s2 = new Scanner(req.getInputStream()).useDelimiter("\\A");
        String policyData = s2.hasNext() ? s2.next() : "";
        try {
            JsonParser.parseString(policyData);
        }
        catch (JsonSyntaxException e) {
            resp.sendError(400, "Invalid JSON.");
            return;
        }
        Policy policy = new Policy();
        policy.setName(name);
        policy.setPolicyData(policyData);
        if (Server.dataStore.getPolicyDao().storeObject(policy)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "An error occurred while attempting to create the group.");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("name");
        if (Server.dataStore.getPolicyDao().deleteObject(name)) {
            resp.setStatus(200);
            return;
        }
        resp.sendError(500, "An error occurred while attempting to delete the blueprint.");
    }
}

