/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import java.math.BigInteger;
import java.util.Optional;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.RevocationRequest;
import net.jami.jams.common.objects.requests.RevocationType;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeDeviceFlow {
    private static final Logger log = LoggerFactory.getLogger(RevokeDeviceFlow.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceRevocationResponse revokeDevice(String username, String deviceId) {
        DeviceRevocationResponse response = new DeviceRevocationResponse();
        try {
            Optional<Device> result = Server.dataStore.getDeviceDao().getByDeviceIdAndOwner(deviceId, username);
            if (result.isEmpty()) {
                log.error("An error occurred while finding the device.");
                return null;
            }
            Device device = result.get();
            BigInteger serialNumber = device.getCertificate().getSerialNumber();
            CertificateAuthority certificateAuthority = Server.certificateAuthority;
            synchronized (certificateAuthority) {
                RevocationRequest request = new RevocationRequest(serialNumber, RevocationType.DEVICE);
                Server.certificateAuthority.revokeCertificate(request);
                Server.certificateAuthority.waitForRevokeCompletion();
                if (((X509CRLHolder)Server.certificateAuthority.getLatestCRL().get()).getRevokedCertificate(serialNumber) != null) {
                    response.setSuccess(true);
                    return response;
                }
                log.error("The certificate has not appeared in the CRL. Operation may have failed.");
                response.setSuccess(false);
                return response;
            }
        }
        catch (Exception e) {
            log.error("An error occurred while revoking the device: {}", (Object)e.getMessage());
            response.setSuccess(false);
            response.setErrorDetails(e.getMessage());
            return response;
        }
    }
}

