/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.AbstractDao;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.database.DatabaseObject;

public class UserProfileDao
extends AbstractDao<UserProfile> {
    public UserProfileDao() {
        this.setTableName("local_directory");
        this.setTClass(UserProfile.class);
    }

    public void insertIfNotExists(UserProfile userProfile) throws SQLException {
        String update = "UPDATE local_directory SET username = ?, firstName = ?, lastName = ?, email = ?, profilePicture = ?, organization=?, phoneNumber=?, phoneNumberExtension=?, faxNumber=?, mobileNumber=?WHERE username = ?";
        String insert = "INSERT INTO local_directory (username, firstName, lastName, email, profilePicture, organization, phoneNumber, phoneNumberExtension, faxNumber, mobileNumber) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        ArrayList<String> params = new ArrayList<String>();
        params.add(userProfile.getUsername());
        params.add(userProfile.getFirstName());
        params.add(userProfile.getLastName());
        params.add(userProfile.getEmail());
        params.add(userProfile.getProfilePicture());
        params.add(userProfile.getOrganization());
        params.add(userProfile.getPhoneNumber());
        params.add(userProfile.getPhoneNumberExtension());
        params.add(userProfile.getFaxNumber());
        params.add(userProfile.getMobileNumber());
        params.add(userProfile.getUsername());
        boolean updateSuccess = this.executeUpdate(update, params);
        if (!updateSuccess) {
            if (!params.isEmpty()) {
                params.remove(params.size() - 1);
            }
            this.executeUpdate(insert, params);
        }
    }

    public List<UserProfile> getAllUserProfile() {
        return this.getObjectsFromResultSet("SELECT * FROM local_directory");
    }

    public List<UserProfile> searchUsername(String username) {
        String query = "SELECT * FROM local_directory WHERE username LIKE ?";
        return this.getObjectsFromResultSet(query, username + "%");
    }

    public List<UserProfile> searchFullName(String name) {
        String query = "SELECT * FROM local_directory WHERE firstName LIKE ? OR lastName LIKE ?";
        name = (String)name + "%";
        return this.getObjectsFromResultSet(query, List.of(name, name));
    }

    public Optional<UserProfile> getByUsername(String username) {
        return this.getFirstObjectFromResultSet("SELECT * FROM local_directory WHERE username = ?", username);
    }

    @Override
    public boolean storeObject(UserProfile object) {
        String query = "INSERT INTO local_directory (firstName, lastName, email, profilePicture, organization, phoneNumber, phoneNumberExtension, faxNumber, mobileNumber, username) VALUES (?,?,?,?,?,?,?,?,?,?)";
        return this.executeInsert(query, (DatabaseObject)object);
    }

    public boolean updateUserProfile(UserProfile userProfile) {
        String query = "UPDATE local_directory SET firstname = ?, lastName = ?, email = ?, profilePicture = ?, organization = ?, phoneNumber = ?, phoneNumberExtension = ?, faxNumber = ?, mobileNumber = ? WHERE username = ?";
        return this.executeInsert(query, (DatabaseObject)userProfile);
    }

    public boolean deleteUserProfile(String username) {
        String query = "DELETE FROM local_directory WHERE username = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(username);
        return this.executeUpdate(query, params);
    }
}

