/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.AbstractDao;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupMappingsDao
extends AbstractDao<UserGroupMapping> {
    private static final Logger log = LoggerFactory.getLogger(UserGroupMappingsDao.class);

    public UserGroupMappingsDao() {
        this.setTableName("usergroupmappings");
        this.setTClass(UserGroupMapping.class);
    }

    public List<UserGroupMapping> getByGroupId(String groupId) {
        return this.getObjectsFromResultSet("SELECT * FROM usergroupmappings WHERE groupId = ?", groupId);
    }

    public List<UserGroupMapping> getByUsername(String username) {
        return this.getObjectsFromResultSet("SELECT * FROM usergroupmappings WHERE username = ?", username);
    }

    public Optional<UserGroupMapping> getByGroupIdAndUsername(String groupId, String username) {
        String query = "SELECT * FROM usergroupmappings WHERE groupId = ? AND username = ?";
        List<String> params = List.of(groupId, username);
        return this.getFirstObjectFromResultSet(query, params);
    }

    @Override
    public boolean storeObject(UserGroupMapping object) {
        String query = "INSERT INTO usergroupmappings (username, groupId) VALUES (?, ?)";
        return this.executeInsert(query, (DatabaseObject)object);
    }

    public boolean deleteObject(String username, String groupId) {
        if (username.equals("*")) {
            String query = "DELETE FROM usergroupmappings WHERE groupId = ?";
            return this.executeUpdate(query, List.of(groupId));
        }
        String query = "DELETE FROM usergroupmappings WHERE username = ? AND groupId = ?";
        return this.executeUpdate(query, List.of(username, groupId));
    }
}

