/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.AbstractDao;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDao
extends AbstractDao<Group> {
    private static final Logger log = LoggerFactory.getLogger(GroupDao.class);

    public GroupDao() {
        this.setTableName("groups");
        this.setTClass(Group.class);
    }

    public List<Group> getAll() {
        return this.getObjectsFromResultSet("SELECT * FROM groups");
    }

    public Optional<Group> getById(String id) {
        return this.getFirstObjectFromResultSet("SELECT * FROM groups WHERE id = ?", List.of(id));
    }

    @Override
    public boolean storeObject(Group object) {
        String query = "INSERT INTO groups (id, name, blueprint) VALUES (?, ?, ?)";
        return this.executeInsert(query, (DatabaseObject)object);
    }

    public boolean updateObject(String id, String name, String blueprint) {
        String query = "UPDATE groups SET name = ?, blueprint = ? WHERE id = ?";
        return this.executeUpdate(query, List.of(name, blueprint, id));
    }

    public boolean deleteObject(String id) {
        String query = "DELETE FROM groups WHERE id = ?";
        return this.executeUpdate(query, List.of(id));
    }
}

