/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Comparator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TLSCipherSuiteComparator
implements Comparator<String>,
Serializable {
    private static final TLSCipherSuiteComparator INSTANCE = new TLSCipherSuiteComparator();
    private static final long serialVersionUID = 7719643162516590858L;

    private TLSCipherSuiteComparator() {
    }

    public static TLSCipherSuiteComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(String s1, String s2) {
        String cipherSuiteName2;
        String cipherSuiteName1 = StaticUtils.toUpperCase(s1).replace('-', '_');
        int scsvOrder = TLSCipherSuiteComparator.getSCSVOrder(cipherSuiteName1, cipherSuiteName2 = StaticUtils.toUpperCase(s2).replace('-', '_'));
        if (scsvOrder != 0) {
            return scsvOrder;
        }
        int prefixOrder = TLSCipherSuiteComparator.getPrefixOrder(cipherSuiteName1, cipherSuiteName2);
        if (prefixOrder != 0) {
            return prefixOrder;
        }
        int blockCipherOrder = TLSCipherSuiteComparator.getBlockCipherOrder(cipherSuiteName1, cipherSuiteName2);
        if (blockCipherOrder != 0) {
            return blockCipherOrder;
        }
        int digestOrder = TLSCipherSuiteComparator.getDigestOrder(cipherSuiteName1, cipherSuiteName2);
        if (digestOrder != 0) {
            return digestOrder;
        }
        return s1.compareTo(s2);
    }

    private static int getSCSVOrder(String cipherSuiteName1, String cipherSuiteName2) {
        if (cipherSuiteName1.endsWith("_SCSV")) {
            if (cipherSuiteName2.endsWith("_SCSV")) {
                return 0;
            }
            return 1;
        }
        if (cipherSuiteName2.endsWith("_SCSV")) {
            return -1;
        }
        return 0;
    }

    private static int getPrefixOrder(String cipherSuiteName1, String cipherSuiteName2) {
        int prefixValue1 = TLSCipherSuiteComparator.getPrefixValue(cipherSuiteName1);
        int prefixValue2 = TLSCipherSuiteComparator.getPrefixValue(cipherSuiteName2);
        return prefixValue1 - prefixValue2;
    }

    private static int getPrefixValue(String cipherSuiteName) {
        if (cipherSuiteName.startsWith("TLS_AES_")) {
            return 1;
        }
        if (cipherSuiteName.startsWith("TLS_CHACHA20_")) {
            return 2;
        }
        if (cipherSuiteName.startsWith("TLS_ECDHE_")) {
            return 3;
        }
        if (cipherSuiteName.startsWith("TLS_DHE_")) {
            return 4;
        }
        if (cipherSuiteName.startsWith("TLS_RSA_")) {
            return 5;
        }
        if (cipherSuiteName.startsWith("TLS_")) {
            return 6;
        }
        if (cipherSuiteName.startsWith("SSL_")) {
            return 7;
        }
        return 8;
    }

    private static int getBlockCipherOrder(String cipherSuiteName1, String cipherSuiteName2) {
        int blockCipherValue1 = TLSCipherSuiteComparator.getBlockCipherValue(cipherSuiteName1);
        int blockCipherValue2 = TLSCipherSuiteComparator.getBlockCipherValue(cipherSuiteName2);
        return blockCipherValue1 - blockCipherValue2;
    }

    private static int getBlockCipherValue(String cipherSuiteName) {
        if (cipherSuiteName.contains("_AES_256_GCM")) {
            return 1;
        }
        if (cipherSuiteName.contains("_AES_128_GCM")) {
            return 2;
        }
        if (cipherSuiteName.contains("_AES") && cipherSuiteName.contains("_GCM")) {
            return 3;
        }
        if (cipherSuiteName.contains("_AES_256")) {
            return 4;
        }
        if (cipherSuiteName.contains("_AES_128")) {
            return 5;
        }
        if (cipherSuiteName.contains("_AES")) {
            return 6;
        }
        if (cipherSuiteName.contains("_CHACHA20")) {
            return 7;
        }
        if (cipherSuiteName.contains("_GCM")) {
            return 8;
        }
        return 9;
    }

    private static int getDigestOrder(String cipherSuiteName1, String cipherSuiteName2) {
        int digestValue1 = TLSCipherSuiteComparator.getDigestValue(cipherSuiteName1);
        int digestValue2 = TLSCipherSuiteComparator.getDigestValue(cipherSuiteName2);
        return digestValue1 - digestValue2;
    }

    private static int getDigestValue(String cipherSuiteName) {
        if (cipherSuiteName.endsWith("_SHA512")) {
            return 1;
        }
        if (cipherSuiteName.endsWith("_SHA384")) {
            return 2;
        }
        if (cipherSuiteName.endsWith("_SHA256")) {
            return 3;
        }
        if (cipherSuiteName.endsWith("_SHA")) {
            return 4;
        }
        return 5;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof TLSCipherSuiteComparator;
    }

    public int hashCode() {
        return 0;
    }
}

