/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentListArgument;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.BooleanValueArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import com.unboundid.util.args.TimestampArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentParser
implements Serializable {
    public static final String PROPERTY_DEFAULT_PROPERTIES_FILE_PATH = ArgumentParser.class.getName() + ".propertiesFilePath";
    public static final String ENV_DEFAULT_PROPERTIES_FILE_PATH = "UNBOUNDID_TOOL_PROPERTIES_FILE_PATH";
    private static final String ARG_NAME_OUTPUT_FILE = "outputFile";
    private static final String ARG_NAME_TEE_OUTPUT = "teeOutput";
    private static final String ARG_NAME_PROPERTIES_FILE_PATH = "propertiesFilePath";
    private static final String ARG_NAME_GENERATE_PROPERTIES_FILE = "generatePropertiesFile";
    private static final String ARG_NAME_NO_PROPERTIES_FILE = "noPropertiesFile";
    private static final String ARG_NAME_SUPPRESS_PROPERTIES_FILE_COMMENT = "suppressPropertiesFileComment";
    private static final long serialVersionUID = 3053102992180360269L;
    private volatile CommandLineTool commandLineTool;
    private volatile File propertiesFileUsed;
    private final int maxTrailingArgs;
    private final int minTrailingArgs;
    private final LinkedHashMap<Character, Argument> namedArgsByShortID;
    private final LinkedHashMap<String, Argument> namedArgsByLongID;
    private final LinkedHashMap<String, SubCommand> subCommandsByName;
    private final List<Argument> namedArgs;
    private final List<ObjectPair<Argument, Set<Argument>>> dependentArgumentSets;
    private final List<Set<Argument>> exclusiveArgumentSets;
    private final List<Set<Argument>> requiredArgumentSets;
    private final List<String> argumentsSetFromPropertiesFile;
    private final List<String> trailingArgs;
    private final List<SubCommand> subCommands;
    private final List<String> additionalCommandDescriptionParagraphs;
    private final String commandDescription;
    private final String commandName;
    private final String trailingArgsPlaceholder;
    private volatile SubCommand parentSubCommand;
    private volatile SubCommand selectedSubCommand;

    public ArgumentParser(String commandName, String commandDescription) throws ArgumentException {
        this(commandName, commandDescription, 0, null);
    }

    public ArgumentParser(String commandName, String commandDescription, int maxTrailingArgs, String trailingArgsPlaceholder) throws ArgumentException {
        this(commandName, commandDescription, 0, maxTrailingArgs, trailingArgsPlaceholder);
    }

    public ArgumentParser(String commandName, String commandDescription, int minTrailingArgs, int maxTrailingArgs, String trailingArgsPlaceholder) throws ArgumentException {
        this(commandName, commandDescription, null, minTrailingArgs, maxTrailingArgs, trailingArgsPlaceholder);
    }

    public ArgumentParser(String commandName, String commandDescription, List<String> additionalCommandDescriptionParagraphs, int minTrailingArgs, int maxTrailingArgs, String trailingArgsPlaceholder) throws ArgumentException {
        if (commandName == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_COMMAND_NAME_NULL.get());
        }
        if (commandDescription == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_COMMAND_DESCRIPTION_NULL.get());
        }
        if (maxTrailingArgs != 0 && trailingArgsPlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_PLACEHOLDER_NULL.get());
        }
        this.commandName = commandName;
        this.commandDescription = commandDescription;
        this.trailingArgsPlaceholder = trailingArgsPlaceholder;
        this.additionalCommandDescriptionParagraphs = additionalCommandDescriptionParagraphs == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(additionalCommandDescriptionParagraphs));
        this.minTrailingArgs = minTrailingArgs >= 0 ? minTrailingArgs : 0;
        this.maxTrailingArgs = maxTrailingArgs >= 0 ? maxTrailingArgs : Integer.MAX_VALUE;
        if (this.minTrailingArgs > this.maxTrailingArgs) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_COUNT_MISMATCH.get(this.minTrailingArgs, this.maxTrailingArgs));
        }
        this.namedArgsByShortID = new LinkedHashMap(StaticUtils.computeMapCapacity(20));
        this.namedArgsByLongID = new LinkedHashMap(StaticUtils.computeMapCapacity(20));
        this.namedArgs = new ArrayList<Argument>(20);
        this.trailingArgs = new ArrayList<String>(20);
        this.dependentArgumentSets = new ArrayList<ObjectPair<Argument, Set<Argument>>>(20);
        this.exclusiveArgumentSets = new ArrayList<Set<Argument>>(20);
        this.requiredArgumentSets = new ArrayList<Set<Argument>>(20);
        this.parentSubCommand = null;
        this.selectedSubCommand = null;
        this.subCommands = new ArrayList<SubCommand>(20);
        this.subCommandsByName = new LinkedHashMap(StaticUtils.computeMapCapacity(20));
        this.propertiesFileUsed = null;
        this.argumentsSetFromPropertiesFile = new ArrayList<String>(20);
        this.commandLineTool = null;
    }

    ArgumentParser(ArgumentParser source, SubCommand subCommand) {
        LinkedHashSet newSet;
        this.commandName = source.commandName;
        this.commandDescription = source.commandDescription;
        this.minTrailingArgs = source.minTrailingArgs;
        this.maxTrailingArgs = source.maxTrailingArgs;
        this.trailingArgsPlaceholder = source.trailingArgsPlaceholder;
        this.additionalCommandDescriptionParagraphs = source.additionalCommandDescriptionParagraphs;
        this.propertiesFileUsed = null;
        this.argumentsSetFromPropertiesFile = new ArrayList<String>(20);
        this.trailingArgs = new ArrayList<String>(20);
        this.namedArgs = new ArrayList<Argument>(source.namedArgs.size());
        this.namedArgsByLongID = new LinkedHashMap(StaticUtils.computeMapCapacity(source.namedArgsByLongID.size()));
        this.namedArgsByShortID = new LinkedHashMap(StaticUtils.computeMapCapacity(source.namedArgsByShortID.size()));
        LinkedHashMap<String, Argument> argsByID = new LinkedHashMap<String, Argument>(StaticUtils.computeMapCapacity(source.namedArgs.size()));
        for (Argument argument : source.namedArgs) {
            Argument a = argument.getCleanCopy();
            try {
                a.setRegistered();
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
            }
            this.namedArgs.add(a);
            argsByID.put(a.getIdentifierString(), a);
            for (Character c : a.getShortIdentifiers(true)) {
                this.namedArgsByShortID.put(c, a);
            }
            for (String s2 : a.getLongIdentifiers(true)) {
                this.namedArgsByLongID.put(StaticUtils.toLowerCase(s2), a);
            }
        }
        this.dependentArgumentSets = new ArrayList<ObjectPair<Argument, Set<Argument>>>(source.dependentArgumentSets.size());
        for (ObjectPair objectPair : source.dependentArgumentSets) {
            Set sourceSet = (Set)objectPair.getSecond();
            LinkedHashSet newSet2 = new LinkedHashSet(StaticUtils.computeMapCapacity(sourceSet.size()));
            for (Argument a : sourceSet) {
                newSet2.add(argsByID.get(a.getIdentifierString()));
            }
            Argument sourceFirst = (Argument)objectPair.getFirst();
            Argument newFirst = (Argument)argsByID.get(sourceFirst.getIdentifierString());
            this.dependentArgumentSets.add(new ObjectPair(newFirst, newSet2));
        }
        this.exclusiveArgumentSets = new ArrayList<Set<Argument>>(source.exclusiveArgumentSets.size());
        for (Set set : source.exclusiveArgumentSets) {
            newSet = new LinkedHashSet(StaticUtils.computeMapCapacity(set.size()));
            for (Argument a : set) {
                newSet.add(argsByID.get(a.getIdentifierString()));
            }
            this.exclusiveArgumentSets.add(newSet);
        }
        this.requiredArgumentSets = new ArrayList<Set<Argument>>(source.requiredArgumentSets.size());
        for (Set set : source.requiredArgumentSets) {
            newSet = new LinkedHashSet(StaticUtils.computeMapCapacity(set.size()));
            for (Argument a : set) {
                newSet.add(argsByID.get(a.getIdentifierString()));
            }
            this.requiredArgumentSets.add(newSet);
        }
        this.parentSubCommand = subCommand;
        this.selectedSubCommand = null;
        this.subCommands = new ArrayList<SubCommand>(source.subCommands.size());
        this.subCommandsByName = new LinkedHashMap(StaticUtils.computeMapCapacity(source.subCommandsByName.size()));
        for (SubCommand subCommand2 : source.subCommands) {
            this.subCommands.add(subCommand2.getCleanCopy());
            for (String name : subCommand2.getNames(true)) {
                this.subCommandsByName.put(StaticUtils.toLowerCase(name), subCommand2);
            }
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public List<String> getAdditionalCommandDescriptionParagraphs() {
        return this.additionalCommandDescriptionParagraphs;
    }

    public boolean allowsTrailingArguments() {
        return this.maxTrailingArgs != 0;
    }

    public boolean requiresTrailingArguments() {
        return this.minTrailingArgs != 0;
    }

    public String getTrailingArgumentsPlaceholder() {
        return this.trailingArgsPlaceholder;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArgs;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArgs;
    }

    public void enablePropertiesFileSupport() throws ArgumentException {
        FileArgument propertiesFilePath = new FileArgument(null, ARG_NAME_PROPERTIES_FILE_PATH, false, 1, null, ArgsMessages.INFO_ARG_DESCRIPTION_PROP_FILE_PATH.get(), true, true, true, false);
        propertiesFilePath.setUsageArgument(true);
        propertiesFilePath.addLongIdentifier("properties-file-path", true);
        this.addArgument(propertiesFilePath);
        FileArgument generatePropertiesFile = new FileArgument(null, ARG_NAME_GENERATE_PROPERTIES_FILE, false, 1, null, ArgsMessages.INFO_ARG_DESCRIPTION_GEN_PROP_FILE.get(), false, true, true, false);
        generatePropertiesFile.setUsageArgument(true);
        generatePropertiesFile.addLongIdentifier("generate-properties-file", true);
        this.addArgument(generatePropertiesFile);
        BooleanArgument noPropertiesFile = new BooleanArgument(null, ARG_NAME_NO_PROPERTIES_FILE, ArgsMessages.INFO_ARG_DESCRIPTION_NO_PROP_FILE.get());
        noPropertiesFile.setUsageArgument(true);
        noPropertiesFile.addLongIdentifier("no-properties-file", true);
        this.addArgument(noPropertiesFile);
        BooleanArgument suppressPropertiesFileComment = new BooleanArgument(null, ARG_NAME_SUPPRESS_PROPERTIES_FILE_COMMENT, 1, ArgsMessages.INFO_ARG_DESCRIPTION_SUPPRESS_PROP_FILE_COMMENT.get());
        suppressPropertiesFileComment.setUsageArgument(true);
        suppressPropertiesFileComment.addLongIdentifier("suppress-properties-file-comment", true);
        this.addArgument(suppressPropertiesFileComment);
        this.addExclusiveArgumentSet(propertiesFilePath, noPropertiesFile, new Argument[0]);
    }

    public File getGeneratedPropertiesFile() {
        Argument a = this.getNamedArgument(ARG_NAME_GENERATE_PROPERTIES_FILE);
        if (a == null || !a.isPresent() || !(a instanceof FileArgument)) {
            return null;
        }
        return ((FileArgument)a).getValue();
    }

    public Argument getNamedArgument(Character shortIdentifier) {
        Validator.ensureNotNull(shortIdentifier);
        return this.namedArgsByShortID.get(shortIdentifier);
    }

    public Argument getNamedArgument(String identifier) {
        Validator.ensureNotNull(identifier);
        if (identifier.startsWith("--") && identifier.length() > 2) {
            return this.namedArgsByLongID.get(StaticUtils.toLowerCase(identifier.substring(2)));
        }
        if (identifier.startsWith("-") && identifier.length() == 2) {
            return this.namedArgsByShortID.get(Character.valueOf(identifier.charAt(1)));
        }
        return this.namedArgsByLongID.get(StaticUtils.toLowerCase(identifier));
    }

    public ArgumentListArgument getArgumentListArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (ArgumentListArgument)a;
    }

    public BooleanArgument getBooleanArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (BooleanArgument)a;
    }

    public BooleanValueArgument getBooleanValueArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (BooleanValueArgument)a;
    }

    public ControlArgument getControlArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (ControlArgument)a;
    }

    public DNArgument getDNArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (DNArgument)a;
    }

    public DurationArgument getDurationArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (DurationArgument)a;
    }

    public FileArgument getFileArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (FileArgument)a;
    }

    public FilterArgument getFilterArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (FilterArgument)a;
    }

    public IntegerArgument getIntegerArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (IntegerArgument)a;
    }

    public ScopeArgument getScopeArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (ScopeArgument)a;
    }

    public StringArgument getStringArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (StringArgument)a;
    }

    public TimestampArgument getTimestampArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (TimestampArgument)a;
    }

    public List<Argument> getNamedArguments() {
        return Collections.unmodifiableList(this.namedArgs);
    }

    public void addArgument(Argument argument) throws ArgumentException {
        argument.setRegistered();
        for (Character c : argument.getShortIdentifiers(true)) {
            if (this.namedArgsByShortID.containsKey(c)) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ID_CONFLICT.get(c));
            }
            if (this.parentSubCommand == null || !this.parentSubCommand.getArgumentParser().namedArgsByShortID.containsKey(c)) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ID_CONFLICT.get(c));
        }
        for (String s2 : argument.getLongIdentifiers(true)) {
            if (this.namedArgsByLongID.containsKey(StaticUtils.toLowerCase(s2))) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ID_CONFLICT.get(s2));
            }
            if (this.parentSubCommand == null || !this.parentSubCommand.getArgumentParser().namedArgsByLongID.containsKey(StaticUtils.toLowerCase(s2))) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ID_CONFLICT.get(s2));
        }
        for (SubCommand sc : this.subCommands) {
            ArgumentParser parser = sc.getArgumentParser();
            for (Character c : argument.getShortIdentifiers(true)) {
                if (!parser.namedArgsByShortID.containsKey(c)) continue;
                throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ID_CONFLICT_WITH_SUBCOMMAND.get(c, sc.getPrimaryName()));
            }
            for (String s3 : argument.getLongIdentifiers(true)) {
                if (!parser.namedArgsByLongID.containsKey(StaticUtils.toLowerCase(s3))) continue;
                throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ID_CONFLICT_WITH_SUBCOMMAND.get(s3, sc.getPrimaryName()));
            }
        }
        for (Character c : argument.getShortIdentifiers(true)) {
            this.namedArgsByShortID.put(c, argument);
        }
        for (String s2 : argument.getLongIdentifiers(true)) {
            this.namedArgsByLongID.put(StaticUtils.toLowerCase(s2), argument);
        }
        this.namedArgs.add(argument);
    }

    public List<ObjectPair<Argument, Set<Argument>>> getDependentArgumentSets() {
        return Collections.unmodifiableList(this.dependentArgumentSets);
    }

    public void addDependentArgumentSet(Argument targetArgument, Collection<Argument> dependentArguments) {
        Validator.ensureNotNull(targetArgument, dependentArguments);
        Validator.ensureFalse(dependentArguments.isEmpty(), "The ArgumentParser.addDependentArgumentSet method must not be called with an empty collection of dependentArguments");
        Validator.ensureTrue(this.namedArgs.contains(targetArgument), "The ArgumentParser.addDependentArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + targetArgument.getIdentifierString() + " argument has not been registered with the argument parser.");
        for (Argument a : dependentArguments) {
            Validator.ensureTrue(this.namedArgs.contains(a), "The ArgumentParser.addDependentArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + a.getIdentifierString() + " argument has not been registered " + "with the argument parser.");
        }
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(dependentArguments);
        this.dependentArgumentSets.add(new ObjectPair<Argument, LinkedHashSet<Argument>>(targetArgument, argSet));
    }

    public void addDependentArgumentSet(Argument targetArgument, Argument dependentArg1, Argument ... remaining) {
        Validator.ensureNotNull(targetArgument, dependentArg1);
        Validator.ensureTrue(this.namedArgs.contains(targetArgument), "The ArgumentParser.addDependentArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + targetArgument.getIdentifierString() + " argument has not been registered with the argument parser.");
        Validator.ensureTrue(this.namedArgs.contains(dependentArg1), "The ArgumentParser.addDependentArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + dependentArg1.getIdentifierString() + " argument has not been registered with the argument parser.");
        if (remaining != null) {
            for (Argument a : remaining) {
                Validator.ensureTrue(this.namedArgs.contains(a), "The ArgumentParser.addDependentArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + a.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
            }
        }
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(StaticUtils.computeMapCapacity(10));
        argSet.add(dependentArg1);
        if (remaining != null) {
            argSet.addAll(Arrays.asList(remaining));
        }
        this.dependentArgumentSets.add(new ObjectPair(targetArgument, argSet));
    }

    public void addMutuallyDependentArgumentSet(Collection<Argument> arguments) {
        Validator.ensureNotNullWithMessage(arguments, "ArgumentParser.addMutuallyDependentArgumentSet.arguments must not be null.");
        Validator.ensureTrue(arguments.size() >= 2, "ArgumentParser.addMutuallyDependentArgumentSet.arguments must contain at least two elements.");
        for (Argument a : arguments) {
            Validator.ensureTrue(this.namedArgs.contains(a), "ArgumentParser.addMutuallyDependentArgumentSet invoked with argument " + a.getIdentifierString() + " that is not registered with the argument parser.");
        }
        HashSet<Argument> allArgsSet = new HashSet<Argument>(arguments);
        for (Argument a : allArgsSet) {
            HashSet<Argument> dependentArgs = new HashSet<Argument>(allArgsSet);
            dependentArgs.remove(a);
            this.addDependentArgumentSet(a, dependentArgs);
        }
    }

    public void addMutuallyDependentArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNullWithMessage(arg1, "ArgumentParser.addMutuallyDependentArgumentSet.arg1 must not be null.");
        Validator.ensureNotNullWithMessage(arg2, "ArgumentParser.addMutuallyDependentArgumentSet.arg2 must not be null.");
        ArrayList<Argument> args = new ArrayList<Argument>(10);
        args.add(arg1);
        args.add(arg2);
        if (remaining != null) {
            args.addAll(Arrays.asList(remaining));
        }
        this.addMutuallyDependentArgumentSet(args);
    }

    public List<Set<Argument>> getExclusiveArgumentSets() {
        return Collections.unmodifiableList(this.exclusiveArgumentSets);
    }

    public void addExclusiveArgumentSet(Collection<Argument> exclusiveArguments) {
        Validator.ensureNotNull(exclusiveArguments);
        for (Argument a : exclusiveArguments) {
            Validator.ensureTrue(this.namedArgs.contains(a), "The ArgumentParser.addExclusiveArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + a.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
        }
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(exclusiveArguments);
        this.exclusiveArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public void addExclusiveArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNull(arg1, arg2);
        Validator.ensureTrue(this.namedArgs.contains(arg1), "The ArgumentParser.addExclusiveArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + arg1.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
        Validator.ensureTrue(this.namedArgs.contains(arg2), "The ArgumentParser.addExclusiveArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + arg2.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
        if (remaining != null) {
            for (Argument a : remaining) {
                Validator.ensureTrue(this.namedArgs.contains(a), "The ArgumentParser.addExclusiveArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + a.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
            }
        }
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(StaticUtils.computeMapCapacity(10));
        argSet.add(arg1);
        argSet.add(arg2);
        if (remaining != null) {
            argSet.addAll(Arrays.asList(remaining));
        }
        this.exclusiveArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public List<Set<Argument>> getRequiredArgumentSets() {
        return Collections.unmodifiableList(this.requiredArgumentSets);
    }

    public void addRequiredArgumentSet(Collection<Argument> requiredArguments) {
        Validator.ensureNotNull(requiredArguments);
        for (Argument a : requiredArguments) {
            Validator.ensureTrue(this.namedArgs.contains(a), "The ArgumentParser.addRequiredArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + a.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
        }
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(requiredArguments);
        this.requiredArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public void addRequiredArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNull(arg1, arg2);
        Validator.ensureTrue(this.namedArgs.contains(arg1), "The ArgumentParser.addRequiredArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + arg1.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
        Validator.ensureTrue(this.namedArgs.contains(arg2), "The ArgumentParser.addRequiredArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + arg2.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
        if (remaining != null) {
            for (Argument a : remaining) {
                Validator.ensureTrue(this.namedArgs.contains(a), "The ArgumentParser.addRequiredArgumentSet method may only be used if all of the provided arguments have already been registered with the argument parser via the ArgumentParser.addArgument method.  The " + a.getIdentifierString() + " argument has not been " + "registered with the argument parser.");
            }
        }
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(StaticUtils.computeMapCapacity(10));
        argSet.add(arg1);
        argSet.add(arg2);
        if (remaining != null) {
            argSet.addAll(Arrays.asList(remaining));
        }
        this.requiredArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public boolean hasSubCommands() {
        return !this.subCommands.isEmpty();
    }

    public SubCommand getSelectedSubCommand() {
        return this.selectedSubCommand;
    }

    void setSelectedSubCommand(SubCommand subcommand) {
        this.selectedSubCommand = subcommand;
        if (subcommand != null) {
            subcommand.setPresent();
        }
    }

    public List<SubCommand> getSubCommands() {
        return Collections.unmodifiableList(this.subCommands);
    }

    public SubCommand getSubCommand(String name) {
        if (name == null) {
            return null;
        }
        return this.subCommandsByName.get(StaticUtils.toLowerCase(name));
    }

    public void addSubCommand(SubCommand subCommand) throws ArgumentException {
        if (subCommand.getGlobalArgumentParser() != null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_SUBCOMMAND_ALREADY_REGISTERED_WITH_PARSER.get());
        }
        if (this.parentSubCommand != null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_CANNOT_CREATE_NESTED_SUBCOMMAND.get(this.parentSubCommand.getPrimaryName()));
        }
        if (this.allowsTrailingArguments()) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_WITH_TRAILING_ARGS_CANNOT_HAVE_SUBCOMMANDS.get());
        }
        for (String name : subCommand.getNames(true)) {
            if (!this.subCommandsByName.containsKey(StaticUtils.toLowerCase(name))) continue;
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_NAME_ALREADY_IN_USE.get(name));
        }
        for (String name : subCommand.getNames(true)) {
            this.subCommandsByName.put(StaticUtils.toLowerCase(name), subCommand);
        }
        this.subCommands.add(subCommand);
        subCommand.setGlobalArgumentParser(this);
    }

    void addSubCommand(String name, SubCommand subCommand) throws ArgumentException {
        String lowerName = StaticUtils.toLowerCase(name);
        if (this.subCommandsByName.containsKey(lowerName)) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_NAME_ALREADY_IN_USE.get(name));
        }
        this.subCommandsByName.put(lowerName, subCommand);
    }

    public List<String> getTrailingArguments() {
        return Collections.unmodifiableList(this.trailingArgs);
    }

    void reset() {
        this.selectedSubCommand = null;
        for (Argument a : this.namedArgs) {
            a.reset();
        }
        this.propertiesFileUsed = null;
        this.argumentsSetFromPropertiesFile.clear();
        this.trailingArgs.clear();
    }

    void resetTrailingArguments() {
        this.trailingArgs.clear();
    }

    void addTrailingArgument(String value) throws ArgumentException {
        if (this.maxTrailingArgs > 0 && this.trailingArgs.size() >= this.maxTrailingArgs) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TOO_MANY_TRAILING_ARGS.get(value, this.commandName, this.maxTrailingArgs));
        }
        this.trailingArgs.add(value);
    }

    public File getPropertiesFileUsed() {
        return this.propertiesFileUsed;
    }

    public List<String> getArgumentsSetFromPropertiesFile() {
        return Collections.unmodifiableList(this.argumentsSetFromPropertiesFile);
    }

    public boolean suppressPropertiesFileComment() {
        BooleanArgument arg = this.getBooleanArgument(ARG_NAME_SUPPRESS_PROPERTIES_FILE_COMMENT);
        return arg != null && arg.isPresent();
    }

    public ArgumentParser getCleanCopy() {
        return new ArgumentParser(this, null);
    }

    public void parse(String[] args) throws ArgumentException {
        ArgumentParser subCommandParser = null;
        boolean inTrailingArgs = false;
        boolean skipFinalValidation = false;
        String subCommandName = null;
        for (int i = 0; i < args.length; ++i) {
            String s2 = args[i];
            if (inTrailingArgs) {
                if (this.maxTrailingArgs == 0) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_NOT_ALLOWED.get(s2, this.commandName));
                }
                if (this.trailingArgs.size() >= this.maxTrailingArgs) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TOO_MANY_TRAILING_ARGS.get(s2, this.commandName, this.maxTrailingArgs));
                }
                this.trailingArgs.add(s2);
                continue;
            }
            if (s2.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (s2.startsWith("--")) {
                int equalPos = s2.indexOf(61);
                String argName = equalPos > 0 ? s2.substring(2, equalPos) : s2.substring(2);
                String lowerName = StaticUtils.toLowerCase(argName);
                Argument a = this.namedArgsByLongID.get(lowerName);
                if (a == null && subCommandParser != null) {
                    a = subCommandParser.namedArgsByLongID.get(lowerName);
                }
                if (a == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_LONG_ID.get(argName));
                }
                if (a.isUsageArgument()) {
                    skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                }
                a.incrementOccurrences();
                if (a.takesValue()) {
                    if (equalPos > 0) {
                        a.addValue(s2.substring(equalPos + 1));
                        continue;
                    }
                    if (++i >= args.length) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ARG_MISSING_VALUE.get(argName));
                    }
                    a.addValue(args[i]);
                    continue;
                }
                if (equalPos <= 0) continue;
                throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ARG_DOESNT_TAKE_VALUE.get(argName));
            }
            if (s2.startsWith("-")) {
                if (s2.length() == 1) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_UNEXPECTED_DASH.get());
                }
                if (s2.length() == 2) {
                    char c = s2.charAt(1);
                    Argument a = this.namedArgsByShortID.get(Character.valueOf(c));
                    if (a == null && subCommandParser != null) {
                        a = subCommandParser.namedArgsByShortID.get(Character.valueOf(c));
                    }
                    if (a == null) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SHORT_ID.get(Character.valueOf(c)));
                    }
                    if (a.isUsageArgument()) {
                        skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                    }
                    a.incrementOccurrences();
                    if (!a.takesValue()) continue;
                    if (++i >= args.length) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ARG_MISSING_VALUE.get(Character.valueOf(c)));
                    }
                    a.addValue(args[i]);
                    continue;
                }
                char c = s2.charAt(1);
                Argument a = this.namedArgsByShortID.get(Character.valueOf(c));
                if (a == null && subCommandParser != null) {
                    a = subCommandParser.namedArgsByShortID.get(Character.valueOf(c));
                }
                if (a == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SHORT_ID.get(Character.valueOf(c)));
                }
                if (a.isUsageArgument()) {
                    skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                }
                a.incrementOccurrences();
                if (a.takesValue()) {
                    a.addValue(s2.substring(2));
                    continue;
                }
                for (int j = 2; j < s2.length(); ++j) {
                    c = s2.charAt(j);
                    a = this.namedArgsByShortID.get(Character.valueOf(c));
                    if (a == null && subCommandParser != null) {
                        a = subCommandParser.namedArgsByShortID.get(Character.valueOf(c));
                    }
                    if (a == null) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUBSEQUENT_SHORT_ARG.get(Character.valueOf(c), s2));
                    }
                    if (a.isUsageArgument()) {
                        skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                    }
                    a.incrementOccurrences();
                    if (!a.takesValue()) continue;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_SUBSEQUENT_SHORT_ARG_TAKES_VALUE.get(Character.valueOf(c), s2));
                }
                continue;
            }
            if (this.subCommands.isEmpty()) {
                inTrailingArgs = true;
                if (this.maxTrailingArgs == 0) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_NOT_ALLOWED.get(s2, this.commandName));
                }
                this.trailingArgs.add(s2);
                continue;
            }
            if (this.selectedSubCommand == null) {
                subCommandName = s2;
                this.selectedSubCommand = this.subCommandsByName.get(StaticUtils.toLowerCase(s2));
                if (this.selectedSubCommand == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SUBCOMMAND.get(s2, this.commandName));
                }
                this.selectedSubCommand.setPresent();
                subCommandParser = this.selectedSubCommand.getArgumentParser();
                continue;
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_CONFLICTING_SUBCOMMANDS.get(subCommandName, s2));
        }
        if (!this.handlePropertiesFile()) {
            return;
        }
        if (skipFinalValidation) {
            return;
        }
        if (!this.subCommands.isEmpty() && this.selectedSubCommand == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_MISSING_SUBCOMMAND.get(this.commandName));
        }
        ArgumentParser.doFinalValidation(this);
        if (this.selectedSubCommand != null) {
            ArgumentParser.doFinalValidation(this.selectedSubCommand.getArgumentParser());
        }
    }

    public void setCommandLineTool(CommandLineTool commandLineTool) {
        this.commandLineTool = commandLineTool;
    }

    private static void doFinalValidation(ArgumentParser parser) throws ArgumentException {
        for (Argument argument : parser.namedArgs) {
            if (!argument.isRequired() || argument.isPresent()) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_MISSING_REQUIRED_ARG.get(argument.getIdentifierString()));
        }
        if (parser.trailingArgs.size() < parser.minTrailingArgs) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_NOT_ENOUGH_TRAILING_ARGS.get(parser.commandName, parser.minTrailingArgs, parser.trailingArgsPlaceholder));
        }
        for (ObjectPair objectPair : parser.dependentArgumentSets) {
            Argument targetArg = (Argument)objectPair.getFirst();
            if (targetArg.getNumOccurrences() <= 0) continue;
            Set argSet = (Set)objectPair.getSecond();
            boolean found = false;
            for (Argument a : argSet) {
                if (a.getNumOccurrences() <= 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (argSet.size() == 1) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_DEPENDENT_CONFLICT_SINGLE.get(targetArg.getIdentifierString(), ((Argument)argSet.iterator().next()).getIdentifierString()));
            }
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            for (Argument a : argSet) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_DEPENDENT_CONFLICT_MULTIPLE.get(targetArg.getIdentifierString(), buffer.toString()));
        }
        for (Set set : parser.exclusiveArgumentSets) {
            Argument setArg = null;
            for (Argument a : set) {
                if (a.getNumOccurrences() <= 0) continue;
                if (setArg == null) {
                    setArg = a;
                    continue;
                }
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(setArg.getIdentifierString(), a.getIdentifierString()));
            }
        }
        for (Set set : parser.requiredArgumentSets) {
            boolean found = false;
            for (Argument a : set) {
                if (a.getNumOccurrences() <= 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            for (Argument a : set) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_REQUIRED_CONFLICT.get(buffer.toString()));
        }
    }

    private static boolean skipFinalValidationBecauseOfArgument(Argument a) {
        if (ARG_NAME_PROPERTIES_FILE_PATH.equals(a.getLongIdentifier()) || ARG_NAME_NO_PROPERTIES_FILE.equals(a.getLongIdentifier()) || ARG_NAME_SUPPRESS_PROPERTIES_FILE_COMMENT.equals(a.getLongIdentifier()) || ARG_NAME_OUTPUT_FILE.equals(a.getLongIdentifier()) || ARG_NAME_TEE_OUTPUT.equals(a.getLongIdentifier())) {
            return false;
        }
        return a.isUsageArgument();
    }

    private boolean handlePropertiesFile() throws ArgumentException {
        File propertiesFile;
        BooleanArgument noPropertiesFile;
        FileArgument generatePropertiesFile;
        FileArgument propertiesFilePath;
        try {
            propertiesFilePath = this.getFileArgument(ARG_NAME_PROPERTIES_FILE_PATH);
            generatePropertiesFile = this.getFileArgument(ARG_NAME_GENERATE_PROPERTIES_FILE);
            noPropertiesFile = this.getBooleanArgument(ARG_NAME_NO_PROPERTIES_FILE);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return true;
        }
        if (propertiesFilePath == null || generatePropertiesFile == null || noPropertiesFile == null) {
            return true;
        }
        if (noPropertiesFile.isPresent()) {
            if (propertiesFilePath.isPresent()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(noPropertiesFile.getIdentifierString(), propertiesFilePath.getIdentifierString()));
            }
            if (generatePropertiesFile.isPresent()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(noPropertiesFile.getIdentifierString(), generatePropertiesFile.getIdentifierString()));
            }
            return true;
        }
        if (generatePropertiesFile.isPresent()) {
            if (propertiesFilePath.isPresent()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(generatePropertiesFile.getIdentifierString(), propertiesFilePath.getIdentifierString()));
            }
            this.generatePropertiesFile(generatePropertiesFile.getValue().getAbsolutePath());
            return false;
        }
        if (propertiesFilePath.isPresent()) {
            File propertiesFile2 = propertiesFilePath.getValue();
            if (!propertiesFile2.exists() || !propertiesFile2.isFile()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_PROPERTIES_FILE.get(propertiesFilePath.getIdentifierString(), propertiesFile2.getAbsolutePath()));
            }
            this.handlePropertiesFile(propertiesFilePath.getValue());
            return true;
        }
        String path = StaticUtils.getSystemProperty(PROPERTY_DEFAULT_PROPERTIES_FILE_PATH);
        if (path == null) {
            path = StaticUtils.getEnvironmentVariable(ENV_DEFAULT_PROPERTIES_FILE_PATH);
        }
        if (path != null && (propertiesFile = new File(path)).exists() && propertiesFile.isFile()) {
            this.handlePropertiesFile(propertiesFile);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePropertiesFile(String path) throws ArgumentException {
        PrintWriter w;
        try {
            w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.ISO_8859_1));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_PARSER_GEN_PROPS_CANNOT_OPEN_FILE.get(path, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_1.get(this.commandName));
            w.println('#');
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_2.get(this.commandName, ARG_NAME_PROPERTIES_FILE_PATH, PROPERTY_DEFAULT_PROPERTIES_FILE_PATH, ENV_DEFAULT_PROPERTIES_FILE_PATH, ARG_NAME_NO_PROPERTIES_FILE));
            w.println('#');
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_3.get());
            w.println('#');
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_4.get());
            w.println('#');
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_5.get(this.commandName));
            for (Argument a : this.getNamedArguments()) {
                this.writeArgumentProperties(w, null, a);
            }
            for (SubCommand sc : this.getSubCommands()) {
                for (Argument a : sc.getArgumentParser().getNamedArguments()) {
                    this.writeArgumentProperties(w, sc, a);
                }
            }
        }
        finally {
            w.close();
        }
    }

    private void writeArgumentProperties(PrintWriter w, SubCommand sc, Argument a) {
        if (a.isUsageArgument() || a.isHidden()) {
            return;
        }
        w.println();
        w.println();
        ArgumentParser.wrapComment(w, a.getDescription());
        w.println('#');
        String constraints = a.getValueConstraints();
        if (constraints != null && !constraints.isEmpty() && !(a instanceof BooleanArgument)) {
            ArgumentParser.wrapComment(w, constraints);
            w.println('#');
        }
        String identifier = a.getLongIdentifier() != null ? a.getLongIdentifier() : a.getIdentifierString();
        String placeholder = a.getValuePlaceholder();
        if (placeholder == null) {
            placeholder = a instanceof BooleanArgument ? "{true|false}" : "";
        }
        String propertyName = sc == null ? this.commandName + '.' + identifier : this.commandName + '.' + sc.getPrimaryName() + '.' + identifier;
        w.println("# " + propertyName + '=' + placeholder);
        if (a.isPresent()) {
            for (String s2 : a.getValueStringRepresentations(false)) {
                w.println(propertyName + '=' + s2);
            }
        }
    }

    private static void wrapComment(PrintWriter w, String s2) {
        for (String line : StaticUtils.wrapLine(s2, 77)) {
            w.println("# " + line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePropertiesFile(File propertiesFile) throws ArgumentException {
        BufferedReader reader;
        String propertiesFilePath = propertiesFile.getAbsolutePath();
        InputStream inputStream = null;
        try {
            PrintStream err;
            PrintStream out;
            List<char[]> cachedPasswords;
            inputStream = new FileInputStream(propertiesFile);
            CommandLineTool tool = this.commandLineTool;
            if (tool == null) {
                cachedPasswords = Collections.emptyList();
                out = System.out;
                err = System.err;
            } else {
                cachedPasswords = tool.getPasswordFileReader().getCachedEncryptionPasswords();
                out = tool.getOut();
                err = tool.getErr();
            }
            ObjectPair<InputStream, char[]> encryptionData = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, cachedPasswords, true, (CharSequence)ArgsMessages.INFO_PARSER_PROMPT_FOR_PROP_FILE_ENC_PW.get(propertiesFile.getAbsolutePath()), (CharSequence)ArgsMessages.ERR_PARSER_WRONG_PROP_FILE_ENC_PW.get(propertiesFile.getAbsolutePath()), out, err);
            inputStream = encryptionData.getFirst();
            if (tool != null && encryptionData.getSecond() != null) {
                tool.getPasswordFileReader().addToEncryptionPasswordCache(encryptionData.getSecond());
            }
            inputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.ISO_8859_1));
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
            }
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_PARSER_CANNOT_OPEN_PROP_FILE.get(propertiesFilePath, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            boolean lineIsContinued = false;
            int lineNumber = 0;
            ArrayList<ObjectPair<Integer, StringBuilder>> propertyLines = new ArrayList<ObjectPair<Integer, StringBuilder>>(10);
            while (true) {
                boolean bl;
                String line;
                try {
                    line = reader.readLine();
                    ++lineNumber;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_ERROR_READING_PROP_FILE.get(propertiesFilePath, StaticUtils.getExceptionMessage(e)), e);
                }
                if (line == null) {
                    if (!lineIsContinued) break;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_PROP_FILE_MISSING_CONTINUATION.get(lineNumber - 1, propertiesFilePath));
                }
                int initialLength = line.length();
                boolean bl2 = bl = (line = StaticUtils.trimLeading(line)).length() < initialLength;
                if (bl && !lineIsContinued) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_PROP_FILE_UNEXPECTED_LEADING_SPACE.get(propertiesFilePath, lineNumber));
                }
                if (line.isEmpty() || line.startsWith("#")) {
                    if (!lineIsContinued) continue;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_PROP_FILE_MISSING_CONTINUATION.get(lineNumber - 1, propertiesFilePath));
                }
                boolean hasTrailingBackslash = line.endsWith("\\");
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                }
                if (lineIsContinued) {
                    ((StringBuilder)((ObjectPair)propertyLines.get(propertyLines.size() - 1)).getSecond()).append(line);
                } else {
                    propertyLines.add(new ObjectPair<Integer, StringBuilder>(lineNumber, new StringBuilder(line)));
                }
                lineIsContinued = hasTrailingBackslash;
            }
            this.propertiesFileUsed = propertiesFile;
            if (propertyLines.isEmpty()) {
                return;
            }
            HashMap<String, ArrayList<String>> propertyMap = new HashMap<String, ArrayList<String>>(StaticUtils.computeMapCapacity(propertyLines.size()));
            for (ObjectPair objectPair : propertyLines) {
                lineNumber = (Integer)objectPair.getFirst();
                String line = ArgumentParser.handleUnicodeEscapes(propertiesFilePath, lineNumber, (StringBuilder)objectPair.getSecond());
                int equalPos = line.indexOf(61);
                if (equalPos <= 0) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_MALFORMED_PROP_LINE.get(propertiesFilePath, lineNumber, line));
                }
                String propertyName = line.substring(0, equalPos).trim();
                String propertyValue = line.substring(equalPos + 1).trim();
                if (propertyValue.isEmpty()) continue;
                boolean prefixedWithToolName = false;
                boolean prefixedWithSubCommandName = false;
                Argument a = this.getNamedArgument(propertyName);
                if (a == null) {
                    if (propertyName.startsWith(this.commandName + '.')) {
                        prefixedWithToolName = true;
                        String basePropertyName = propertyName.substring(this.commandName.length() + 1);
                        a = this.getNamedArgument(basePropertyName);
                        if (a == null) {
                            int periodPos = basePropertyName.indexOf(46);
                            if (periodPos > 0) {
                                String subCommandName = basePropertyName.substring(0, periodPos);
                                if (this.selectedSubCommand != null && this.selectedSubCommand.hasName(subCommandName)) {
                                    prefixedWithSubCommandName = true;
                                    basePropertyName = basePropertyName.substring(periodPos + 1);
                                    a = this.selectedSubCommand.getArgumentParser().getNamedArgument(basePropertyName);
                                }
                            } else if (this.selectedSubCommand != null) {
                                a = this.selectedSubCommand.getArgumentParser().getNamedArgument(basePropertyName);
                            }
                        }
                    } else if (this.selectedSubCommand != null) {
                        a = this.selectedSubCommand.getArgumentParser().getNamedArgument(propertyName);
                    }
                }
                if (a == null) continue;
                String canonicalPropertyName = prefixedWithToolName ? (prefixedWithSubCommandName ? this.commandName + '.' + this.selectedSubCommand.getPrimaryName() + '.' + a.getIdentifierString() : this.commandName + '.' + a.getIdentifierString()) : a.getIdentifierString();
                ArrayList<String> valueList = propertyMap.get(canonicalPropertyName);
                if (valueList == null) {
                    valueList = new ArrayList(5);
                    propertyMap.put(canonicalPropertyName, valueList);
                }
                valueList.add(propertyValue);
            }
            this.setArgsFromPropertiesFile(propertyMap, false);
            if (this.selectedSubCommand != null) {
                this.setArgsFromPropertiesFile(propertyMap, true);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    static String handleUnicodeEscapes(String propertiesFilePath, int lineNumber, StringBuilder buffer) throws ArgumentException {
        for (int pos = 0; pos < buffer.length(); ++pos) {
            char c = buffer.charAt(pos);
            if (c != '\\' || pos > buffer.length() - 5) continue;
            char nextChar = buffer.charAt(pos + 1);
            if (nextChar == 'u' || nextChar == 'U') {
                try {
                    String hexDigits = buffer.substring(pos + 2, pos + 6);
                    byte[] bytes = StaticUtils.fromHex(hexDigits);
                    int i = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
                    buffer.setCharAt(pos, (char)i);
                    for (int j = 0; j < 5; ++j) {
                        buffer.deleteCharAt(pos + 1);
                    }
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_MALFORMED_UNICODE_ESCAPE.get(propertiesFilePath, lineNumber), e);
                }
            }
            buffer.deleteCharAt(pos);
        }
        return buffer.toString();
    }

    private void setArgsFromPropertiesFile(Map<String, ArrayList<String>> propertyMap, boolean useSubCommand) throws ArgumentException {
        ArgumentParser p = useSubCommand ? this.selectedSubCommand.getArgumentParser() : this;
        for (Argument a : p.namedArgs) {
            if (a.getNumOccurrences() > 0) continue;
            boolean exclusiveArgumentHasValue = false;
            block1: for (Set<Argument> exclusiveArgumentSet : this.exclusiveArgumentSets) {
                if (!exclusiveArgumentSet.contains(a)) continue;
                for (Argument exclusiveArg : exclusiveArgumentSet) {
                    if (exclusiveArg.getNumOccurrences() <= 0) continue;
                    exclusiveArgumentHasValue = true;
                    break block1;
                }
            }
            if (exclusiveArgumentHasValue) continue;
            List values = null;
            if (useSubCommand) {
                values = propertyMap.get(this.commandName + '.' + this.selectedSubCommand.getPrimaryName() + '.' + a.getIdentifierString());
            }
            if (values == null) {
                values = propertyMap.get(this.commandName + '.' + a.getIdentifierString());
            }
            if (values == null) {
                values = propertyMap.get(a.getIdentifierString());
            }
            if (values == null) continue;
            for (String value : values) {
                if (a instanceof BooleanArgument) {
                    BooleanValueArgument bva = new BooleanValueArgument(a.getShortIdentifier(), a.getLongIdentifier(), false, null, a.getDescription());
                    bva.addValue(value);
                    if (!bva.getValue().booleanValue()) continue;
                    a.incrementOccurrences();
                    this.argumentsSetFromPropertiesFile.add(a.getIdentifierString());
                    continue;
                }
                a.addValue(value);
                a.incrementOccurrences();
                this.argumentsSetFromPropertiesFile.add(a.getIdentifierString());
                if (a.isSensitive()) {
                    this.argumentsSetFromPropertiesFile.add("***REDACTED***");
                    continue;
                }
                this.argumentsSetFromPropertiesFile.add(value);
            }
        }
    }

    public List<String> getUsage(int maxWidth) {
        if (this.selectedSubCommand != null) {
            return this.getSubCommandUsage(maxWidth);
        }
        ArrayList<String> lines = new ArrayList<String>(100);
        lines.addAll(StaticUtils.wrapLine(this.commandDescription, maxWidth));
        lines.add("");
        for (String additionalDescriptionParagraph : this.additionalCommandDescriptionParagraphs) {
            lines.addAll(StaticUtils.wrapLine(additionalDescriptionParagraph, maxWidth));
            lines.add("");
        }
        if (!this.subCommands.isEmpty() && this.subCommands.size() < 10) {
            lines.add(ArgsMessages.INFO_USAGE_SUBCOMMANDS_HEADER.get());
            lines.add("");
            for (SubCommand sc : this.subCommands) {
                StringBuilder nameBuffer = new StringBuilder();
                nameBuffer.append("  ");
                Iterator<String> nameIterator = sc.getNames(false).iterator();
                while (nameIterator.hasNext()) {
                    nameBuffer.append(nameIterator.next());
                    if (!nameIterator.hasNext()) continue;
                    nameBuffer.append(", ");
                }
                lines.add(nameBuffer.toString());
                for (String string : StaticUtils.wrapLine(sc.getDescription(), maxWidth - 4)) {
                    lines.add("    " + string);
                }
                lines.add("");
            }
        }
        if (!this.subCommands.isEmpty()) {
            lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_SUBCOMMAND_USAGE.get(this.commandName), maxWidth));
        } else if (this.namedArgs.isEmpty()) {
            if (this.maxTrailingArgs == 0) {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_NOOPTIONS_NOTRAILING.get(this.commandName), maxWidth));
            } else {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_NOOPTIONS_TRAILING.get(this.commandName, this.trailingArgsPlaceholder), maxWidth));
            }
        } else if (this.maxTrailingArgs == 0) {
            lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_OPTIONS_NOTRAILING.get(this.commandName), maxWidth));
        } else {
            lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_OPTIONS_TRAILING.get(this.commandName, this.trailingArgsPlaceholder), maxWidth));
        }
        if (!this.namedArgs.isEmpty()) {
            lines.add("");
            lines.add(ArgsMessages.INFO_USAGE_OPTIONS_INCLUDE.get());
            boolean hasRequired = false;
            LinkedHashMap<String, ArrayList<Argument>> argumentsByGroup = new LinkedHashMap<String, ArrayList<Argument>>(StaticUtils.computeMapCapacity(10));
            ArrayList<Argument> argumentsWithoutGroup = new ArrayList<Argument>(this.namedArgs.size());
            ArrayList<Argument> usageArguments = new ArrayList<Argument>(this.namedArgs.size());
            for (Argument argument : this.namedArgs) {
                String argumentGroup;
                if (argument.isHidden()) continue;
                if (argument.isRequired() && !argument.hasDefaultValue()) {
                    hasRequired = true;
                }
                if ((argumentGroup = argument.getArgumentGroupName()) == null) {
                    if (argument.isUsageArgument()) {
                        usageArguments.add(argument);
                        continue;
                    }
                    argumentsWithoutGroup.add(argument);
                    continue;
                }
                ArrayList<Argument> groupArgs = (ArrayList<Argument>)argumentsByGroup.get(argumentGroup);
                if (groupArgs == null) {
                    groupArgs = new ArrayList<Argument>(10);
                    argumentsByGroup.put(argumentGroup, groupArgs);
                }
                groupArgs.add(argument);
            }
            for (Map.Entry entry : argumentsByGroup.entrySet()) {
                lines.add("");
                lines.add("  " + (String)entry.getKey());
                lines.add("");
                for (Argument a : (List)entry.getValue()) {
                    ArgumentParser.getArgUsage(a, lines, true, maxWidth);
                }
            }
            if (!argumentsWithoutGroup.isEmpty()) {
                if (argumentsByGroup.isEmpty()) {
                    for (Argument argument : argumentsWithoutGroup) {
                        ArgumentParser.getArgUsage(argument, lines, false, maxWidth);
                    }
                } else {
                    lines.add("");
                    lines.add("  " + ArgsMessages.INFO_USAGE_UNGROUPED_ARGS.get());
                    lines.add("");
                    for (Argument argument : argumentsWithoutGroup) {
                        ArgumentParser.getArgUsage(argument, lines, true, maxWidth);
                    }
                }
            }
            if (!usageArguments.isEmpty()) {
                if (argumentsByGroup.isEmpty()) {
                    for (Argument argument : usageArguments) {
                        ArgumentParser.getArgUsage(argument, lines, false, maxWidth);
                    }
                } else {
                    lines.add("");
                    lines.add("  " + ArgsMessages.INFO_USAGE_USAGE_ARGS.get());
                    lines.add("");
                    for (Argument argument : usageArguments) {
                        ArgumentParser.getArgUsage(argument, lines, true, maxWidth);
                    }
                }
            }
            if (hasRequired) {
                lines.add("");
                if (argumentsByGroup.isEmpty()) {
                    lines.add("* " + ArgsMessages.INFO_USAGE_ARG_IS_REQUIRED.get());
                } else {
                    lines.add("  * " + ArgsMessages.INFO_USAGE_ARG_IS_REQUIRED.get());
                }
            }
        }
        return lines;
    }

    private List<String> getSubCommandUsage(int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>(100);
        lines.addAll(StaticUtils.wrapLine(this.selectedSubCommand.getDescription(), maxWidth));
        lines.add("");
        lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_SUBCOMMAND_USAGE_OPTIONS.get(this.commandName, this.selectedSubCommand.getPrimaryName()), maxWidth));
        ArgumentParser parser = this.selectedSubCommand.getArgumentParser();
        if (!parser.namedArgs.isEmpty()) {
            lines.add("");
            lines.add(ArgsMessages.INFO_USAGE_OPTIONS_INCLUDE.get());
            boolean hasRequired = false;
            LinkedHashMap<String, ArrayList<Argument>> argumentsByGroup = new LinkedHashMap<String, ArrayList<Argument>>(StaticUtils.computeMapCapacity(10));
            ArrayList<Argument> argumentsWithoutGroup = new ArrayList<Argument>(parser.namedArgs.size());
            ArrayList<Argument> usageArguments = new ArrayList<Argument>(parser.namedArgs.size());
            for (Argument argument : parser.namedArgs) {
                String argumentGroup;
                if (argument.isHidden()) continue;
                if (argument.isRequired() && !argument.hasDefaultValue()) {
                    hasRequired = true;
                }
                if ((argumentGroup = argument.getArgumentGroupName()) == null) {
                    if (argument.isUsageArgument()) {
                        usageArguments.add(argument);
                        continue;
                    }
                    argumentsWithoutGroup.add(argument);
                    continue;
                }
                ArrayList<Argument> groupArgs = (ArrayList<Argument>)argumentsByGroup.get(argumentGroup);
                if (groupArgs == null) {
                    groupArgs = new ArrayList<Argument>(10);
                    argumentsByGroup.put(argumentGroup, groupArgs);
                }
                groupArgs.add(argument);
            }
            for (Map.Entry entry : argumentsByGroup.entrySet()) {
                lines.add("");
                lines.add("  " + (String)entry.getKey());
                lines.add("");
                for (Argument a : (List)entry.getValue()) {
                    ArgumentParser.getArgUsage(a, lines, true, maxWidth);
                }
            }
            if (!argumentsWithoutGroup.isEmpty()) {
                if (argumentsByGroup.isEmpty()) {
                    for (Argument argument : argumentsWithoutGroup) {
                        ArgumentParser.getArgUsage(argument, lines, false, maxWidth);
                    }
                } else {
                    lines.add("");
                    lines.add("  " + ArgsMessages.INFO_USAGE_UNGROUPED_ARGS.get());
                    lines.add("");
                    for (Argument argument : argumentsWithoutGroup) {
                        ArgumentParser.getArgUsage(argument, lines, true, maxWidth);
                    }
                }
            }
            if (!usageArguments.isEmpty()) {
                if (argumentsByGroup.isEmpty()) {
                    for (Argument argument : usageArguments) {
                        ArgumentParser.getArgUsage(argument, lines, false, maxWidth);
                    }
                } else {
                    lines.add("");
                    lines.add("  " + ArgsMessages.INFO_USAGE_USAGE_ARGS.get());
                    lines.add("");
                    for (Argument argument : usageArguments) {
                        ArgumentParser.getArgUsage(argument, lines, true, maxWidth);
                    }
                }
            }
            if (hasRequired) {
                lines.add("");
                if (argumentsByGroup.isEmpty()) {
                    lines.add("* " + ArgsMessages.INFO_USAGE_ARG_IS_REQUIRED.get());
                } else {
                    lines.add("  * " + ArgsMessages.INFO_USAGE_ARG_IS_REQUIRED.get());
                }
            }
        }
        return lines;
    }

    private static void getArgUsage(Argument a, List<String> lines, boolean indent, int maxWidth) {
        int subsequentLineWidth;
        StringBuilder argLine = new StringBuilder();
        if (indent && maxWidth > 10) {
            if (a.isRequired() && !a.hasDefaultValue()) {
                argLine.append("  * ");
            } else {
                argLine.append("    ");
            }
        } else if (a.isRequired() && !a.hasDefaultValue()) {
            argLine.append("* ");
        }
        boolean first = true;
        for (Character c : a.getShortIdentifiers(false)) {
            if (first) {
                argLine.append('-');
                first = false;
            } else {
                argLine.append(", -");
            }
            argLine.append(c);
        }
        for (String s2 : a.getLongIdentifiers(false)) {
            if (first) {
                argLine.append("--");
                first = false;
            } else {
                argLine.append(", --");
            }
            argLine.append(s2);
        }
        String valuePlaceholder = a.getValuePlaceholder();
        if (valuePlaceholder != null) {
            argLine.append(' ');
            argLine.append(valuePlaceholder);
        }
        if ((subsequentLineWidth = maxWidth - 4) < 4) {
            subsequentLineWidth = maxWidth;
        }
        List<String> identifierLines = StaticUtils.wrapLine(argLine.toString(), maxWidth, subsequentLineWidth);
        for (int i = 0; i < identifierLines.size(); ++i) {
            if (i == 0) {
                lines.add(identifierLines.get(0));
                continue;
            }
            lines.add("    " + identifierLines.get(i));
        }
        String description = a.getDescription();
        if (maxWidth > 10) {
            String indentString = indent ? "        " : "    ";
            List<String> descLines = StaticUtils.wrapLine(description, maxWidth - indentString.length());
            for (String s3 : descLines) {
                lines.add(indentString + s3);
            }
        } else {
            lines.addAll(StaticUtils.wrapLine(description, maxWidth));
        }
    }

    public void getUsage(OutputStream outputStream, int maxWidth) throws IOException {
        List<String> usageLines = this.getUsage(maxWidth);
        for (String s2 : usageLines) {
            outputStream.write(StaticUtils.getBytes(s2));
            outputStream.write(StaticUtils.EOL_BYTES);
        }
    }

    public String getUsageString(int maxWidth) {
        StringBuilder buffer = new StringBuilder();
        this.getUsageString(buffer, maxWidth);
        return buffer.toString();
    }

    public void getUsageString(StringBuilder buffer, int maxWidth) {
        for (String line : this.getUsage(maxWidth)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ArgumentParser(commandName='");
        buffer.append(this.commandName);
        buffer.append("', commandDescription={");
        buffer.append('\'');
        buffer.append(this.commandDescription);
        buffer.append('\'');
        if (this.additionalCommandDescriptionParagraphs != null) {
            for (String additionalParagraph : this.additionalCommandDescriptionParagraphs) {
                buffer.append(", '");
                buffer.append(additionalParagraph);
                buffer.append('\'');
            }
        }
        buffer.append("}, minTrailingArgs=");
        buffer.append(this.minTrailingArgs);
        buffer.append(", maxTrailingArgs=");
        buffer.append(this.maxTrailingArgs);
        if (this.trailingArgsPlaceholder != null) {
            buffer.append(", trailingArgsPlaceholder='");
            buffer.append(this.trailingArgsPlaceholder);
            buffer.append('\'');
        }
        buffer.append(", namedArgs={");
        Iterator<Argument> iterator = this.namedArgs.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        if (!this.subCommands.isEmpty()) {
            buffer.append(", subCommands={");
            Iterator<SubCommand> subCommandIterator = this.subCommands.iterator();
            while (subCommandIterator.hasNext()) {
                subCommandIterator.next().toString(buffer);
                if (!subCommandIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

