/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.FileRetentionTaskTimestampFormat;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.DurationArgument;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FileRetentionTask
extends Task {
    static final String FILE_RETENTION_TASK_CLASS = "com.unboundid.directory.server.tasks.FileRetentionTask";
    private static final String ATTR_TARGET_DIRECTORY = "ds-task-file-retention-target-directory";
    private static final String ATTR_FILENAME_PATTERN = "ds-task-file-retention-filename-pattern";
    private static final String ATTR_TIMESTAMP_FORMAT = "ds-task-file-retention-timestamp-format";
    private static final String ATTR_RETAIN_FILE_COUNT = "ds-task-file-retention-retain-file-count";
    private static final String ATTR_RETAIN_FILE_AGE = "ds-task-file-retention-retain-file-age";
    private static final String ATTR_RETAIN_AGGREGATE_FILE_SIZE_BYTES = "ds-task-file-retention-retain-aggregate-file-size-bytes";
    private static final String OC_FILE_RETENTION_TASK = "ds-task-file-retention";
    private static final TaskProperty PROPERTY_TARGET_DIRECTORY = new TaskProperty("ds-task-file-retention-target-directory", TaskMessages.INFO_FILE_RETENTION_DISPLAY_NAME_TARGET_DIRECTORY.get(), TaskMessages.INFO_FILE_RETENTION_DESCRIPTION_TARGET_DIRECTORY.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_FILENAME_PATTERN = new TaskProperty("ds-task-file-retention-filename-pattern", TaskMessages.INFO_FILE_RETENTION_DISPLAY_NAME_FILENAME_PATTERN.get(), TaskMessages.INFO_FILE_RETENTION_DESCRIPTION_FILENAME_PATTERN.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_TIMESTAMP_FORMAT = new TaskProperty("ds-task-file-retention-timestamp-format", TaskMessages.INFO_FILE_RETENTION_DISPLAY_NAME_TIMESTAMP_FORMAT.get(), TaskMessages.INFO_FILE_RETENTION_DESCRIPTION_TIMESTAMP_FORMAT.get(), String.class, true, false, false, new String[]{FileRetentionTaskTimestampFormat.GENERALIZED_TIME_UTC_WITH_MILLISECONDS.name(), FileRetentionTaskTimestampFormat.GENERALIZED_TIME_UTC_WITH_SECONDS.name(), FileRetentionTaskTimestampFormat.GENERALIZED_TIME_UTC_WITH_MINUTES.name(), FileRetentionTaskTimestampFormat.LOCAL_TIME_WITH_MILLISECONDS.name(), FileRetentionTaskTimestampFormat.LOCAL_TIME_WITH_SECONDS.name(), FileRetentionTaskTimestampFormat.LOCAL_TIME_WITH_MINUTES.name(), FileRetentionTaskTimestampFormat.LOCAL_DATE.name()});
    private static final TaskProperty PROPERTY_RETAIN_FILE_COUNT = new TaskProperty("ds-task-file-retention-retain-file-count", TaskMessages.INFO_FILE_RETENTION_DISPLAY_NAME_RETAIN_COUNT.get(), TaskMessages.INFO_FILE_RETENTION_DESCRIPTION_RETAIN_COUNT.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_RETAIN_FILE_AGE_MILLIS = new TaskProperty("ds-task-file-retention-retain-file-age", TaskMessages.INFO_FILE_RETENTION_DISPLAY_NAME_RETAIN_AGE.get(), TaskMessages.INFO_FILE_RETENTION_DESCRIPTION_RETAIN_AGE.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_RETAIN_AGGREGATE_FILE_SIZE_BYTES = new TaskProperty("ds-task-file-retention-retain-aggregate-file-size-bytes", TaskMessages.INFO_FILE_RETENTION_DISPLAY_NAME_RETAIN_SIZE.get(), TaskMessages.INFO_FILE_RETENTION_DESCRIPTION_RETAIN_SIZE.get(), Long.class, false, false, false);
    private static final long serialVersionUID = 7401251158315611295L;
    private final FileRetentionTaskTimestampFormat timestampFormat;
    private final Integer retainFileCount;
    private final Long retainAggregateFileSizeBytes;
    private final Long retainFileAgeMillis;
    private final String filenamePattern;
    private final String targetDirectory;

    public FileRetentionTask() {
        this.targetDirectory = null;
        this.filenamePattern = null;
        this.timestampFormat = null;
        this.retainFileCount = null;
        this.retainFileAgeMillis = null;
        this.retainAggregateFileSizeBytes = null;
    }

    public FileRetentionTask(String targetDirectory, String filenamePattern, FileRetentionTaskTimestampFormat timestampFormat, Integer retainFileCount, Long retainFileAgeMillis, Long retainAggregateFileSizeBytes) {
        this(null, targetDirectory, filenamePattern, timestampFormat, retainFileCount, retainFileAgeMillis, retainAggregateFileSizeBytes, null, null, null, null, null, null, null, null, null, null);
    }

    public FileRetentionTask(String taskID, String targetDirectory, String filenamePattern, FileRetentionTaskTimestampFormat timestampFormat, Integer retainFileCount, Long retainFileAgeMillis, Long retainAggregateFileSizeBytes, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) {
        super(taskID, FILE_RETENTION_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNullOrEmpty(targetDirectory, "FileRetentionTask.targetDirectory must not be null or empty");
        Validator.ensureNotNullOrEmpty(filenamePattern, "FileRetentionTask.filenamePattern must not be null or empty");
        Validator.ensureNotNullWithMessage((Object)timestampFormat, "FileRetentionTask.timestampFormat must not be null");
        Validator.ensureTrue(retainFileCount != null || retainFileAgeMillis != null || retainAggregateFileSizeBytes != null, "At least one of retainFileCount, retainFileAgeMillis, and retainAggregateFileSizeBytes must be non-null");
        Validator.ensureTrue(retainFileCount == null || retainFileCount >= 0, "FileRetentionTask.retainFileCount must not be negative");
        Validator.ensureTrue(retainFileAgeMillis == null || retainFileAgeMillis > 0L, "FileRetentionTask.retainFileAgeMillis must not be negative or zero");
        Validator.ensureTrue(retainAggregateFileSizeBytes == null || retainAggregateFileSizeBytes > 0L, "FileRetentionTask.retainAggregateFileSizeBytes must not be negative or zero");
        this.targetDirectory = targetDirectory;
        this.filenamePattern = filenamePattern;
        this.timestampFormat = timestampFormat;
        this.retainFileCount = retainFileCount;
        this.retainFileAgeMillis = retainFileAgeMillis;
        this.retainAggregateFileSizeBytes = retainAggregateFileSizeBytes;
    }

    public FileRetentionTask(Entry entry) throws TaskException {
        super(entry);
        this.targetDirectory = entry.getAttributeValue(ATTR_TARGET_DIRECTORY);
        if (this.targetDirectory == null || this.targetDirectory.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_TARGET_DIRECTORY));
        }
        this.filenamePattern = entry.getAttributeValue(ATTR_FILENAME_PATTERN);
        if (this.filenamePattern == null || this.filenamePattern.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_FILENAME_PATTERN));
        }
        String timestampFormatName = entry.getAttributeValue(ATTR_TIMESTAMP_FORMAT);
        if (timestampFormatName == null) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_TIMESTAMP_FORMAT));
        }
        this.timestampFormat = FileRetentionTaskTimestampFormat.forName(timestampFormatName);
        if (this.timestampFormat == null) {
            StringBuilder validFormats = new StringBuilder();
            for (FileRetentionTaskTimestampFormat f : FileRetentionTaskTimestampFormat.values()) {
                if (validFormats.length() > 0) {
                    validFormats.append(", ");
                }
                validFormats.append(f.name());
            }
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_INVALID_TIMESTAMP_FORMAT.get(entry.getDN(), timestampFormatName, validFormats.toString()));
        }
        String retainFileCountString = entry.getAttributeValue(ATTR_RETAIN_FILE_COUNT);
        if (retainFileCountString == null) {
            this.retainFileCount = null;
        } else {
            try {
                this.retainFileCount = Integer.parseInt(retainFileCountString);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_INVALID_RETAIN_COUNT.get(entry.getDN(), retainFileCountString), e);
            }
            if (this.retainFileCount < 0) {
                throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_INVALID_RETAIN_COUNT.get(entry.getDN(), retainFileCountString));
            }
        }
        String retainFileAgeString = entry.getAttributeValue(ATTR_RETAIN_FILE_AGE);
        if (retainFileAgeString == null) {
            this.retainFileAgeMillis = null;
        } else {
            try {
                this.retainFileAgeMillis = DurationArgument.parseDuration(retainFileAgeString, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_INVALID_RETAIN_AGE.get(entry.getDN(), retainFileAgeString, StaticUtils.getExceptionMessage(e)), e);
            }
        }
        String retainAggregateFileSizeBytesString = entry.getAttributeValue(ATTR_RETAIN_AGGREGATE_FILE_SIZE_BYTES);
        if (retainAggregateFileSizeBytesString == null) {
            this.retainAggregateFileSizeBytes = null;
        } else {
            try {
                this.retainAggregateFileSizeBytes = Long.parseLong(retainAggregateFileSizeBytesString);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_INVALID_RETAIN_SIZE.get(entry.getDN(), retainAggregateFileSizeBytesString), e);
            }
            if (this.retainAggregateFileSizeBytes <= 0L) {
                throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_INVALID_RETAIN_SIZE.get(entry.getDN(), retainAggregateFileSizeBytesString));
            }
        }
        if (this.retainFileCount == null && this.retainFileAgeMillis == null && this.retainAggregateFileSizeBytes == null) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_ENTRY_MISSING_RETENTION_CRITERIA.get(entry.getDN(), ATTR_RETAIN_FILE_COUNT, ATTR_RETAIN_FILE_AGE, ATTR_RETAIN_AGGREGATE_FILE_SIZE_BYTES));
        }
    }

    public FileRetentionTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(FILE_RETENTION_TASK_CLASS, properties);
        String directory = null;
        String pattern = null;
        FileRetentionTaskTimestampFormat format = null;
        Long count = null;
        Long age = null;
        Long size = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            switch (attrName) {
                case "ds-task-file-retention-target-directory": {
                    directory = FileRetentionTask.parseString(p, values, null);
                    break;
                }
                case "ds-task-file-retention-filename-pattern": {
                    pattern = FileRetentionTask.parseString(p, values, null);
                    break;
                }
                case "ds-task-file-retention-timestamp-format": {
                    String formatName = FileRetentionTask.parseString(p, values, null);
                    format = FileRetentionTaskTimestampFormat.forName(formatName);
                    break;
                }
                case "ds-task-file-retention-retain-file-count": {
                    count = FileRetentionTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-file-retention-retain-file-age": {
                    age = FileRetentionTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-file-retention-retain-aggregate-file-size-bytes": {
                    size = FileRetentionTask.parseLong(p, values, null);
                }
            }
        }
        this.targetDirectory = directory;
        this.filenamePattern = pattern;
        this.timestampFormat = format;
        this.retainFileAgeMillis = age;
        this.retainAggregateFileSizeBytes = size;
        this.retainFileCount = count == null ? null : Integer.valueOf(count.intValue());
        if (this.targetDirectory == null || this.targetDirectory.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_MISSING_REQUIRED_PROPERTY.get(ATTR_TARGET_DIRECTORY));
        }
        if (this.filenamePattern == null || this.filenamePattern.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_MISSING_REQUIRED_PROPERTY.get(ATTR_FILENAME_PATTERN));
        }
        if (this.timestampFormat == null) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_MISSING_REQUIRED_PROPERTY.get(ATTR_TIMESTAMP_FORMAT));
        }
        if (this.retainFileCount == null && this.retainFileAgeMillis == null && this.retainAggregateFileSizeBytes == null) {
            throw new TaskException(TaskMessages.ERR_FILE_RETENTION_MISSING_RETENTION_PROPERTY.get(ATTR_RETAIN_FILE_COUNT, ATTR_RETAIN_FILE_AGE, ATTR_RETAIN_AGGREGATE_FILE_SIZE_BYTES));
        }
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_FILE_RETENTION.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_FILE_RETENTION.get();
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    public FileRetentionTaskTimestampFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public Integer getRetainFileCount() {
        return this.retainFileCount;
    }

    public Long getRetainFileAgeMillis() {
        return this.retainFileAgeMillis;
    }

    public Long getRetainAggregateFileSizeBytes() {
        return this.retainAggregateFileSizeBytes;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_FILE_RETENTION_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        attrList.add(new Attribute(ATTR_TARGET_DIRECTORY, this.targetDirectory));
        attrList.add(new Attribute(ATTR_FILENAME_PATTERN, this.filenamePattern));
        attrList.add(new Attribute(ATTR_TIMESTAMP_FORMAT, this.timestampFormat.name()));
        if (this.retainFileCount != null) {
            attrList.add(new Attribute(ATTR_RETAIN_FILE_COUNT, String.valueOf(this.retainFileCount)));
        }
        if (this.retainFileAgeMillis != null) {
            long retainFileAgeNanos = this.retainFileAgeMillis * 1000000L;
            String retainFileAgeString = DurationArgument.nanosToDuration(retainFileAgeNanos);
            attrList.add(new Attribute(ATTR_RETAIN_FILE_AGE, retainFileAgeString));
        }
        if (this.retainAggregateFileSizeBytes != null) {
            attrList.add(new Attribute(ATTR_RETAIN_AGGREGATE_FILE_SIZE_BYTES, String.valueOf(this.retainAggregateFileSizeBytes)));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_TARGET_DIRECTORY, PROPERTY_FILENAME_PATTERN, PROPERTY_TIMESTAMP_FORMAT, PROPERTY_RETAIN_FILE_COUNT, PROPERTY_RETAIN_FILE_AGE_MILLIS, PROPERTY_RETAIN_AGGREGATE_FILE_SIZE_BYTES));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(6));
        props.put(PROPERTY_TARGET_DIRECTORY, Collections.singletonList(this.targetDirectory));
        props.put(PROPERTY_FILENAME_PATTERN, Collections.singletonList(this.filenamePattern));
        props.put(PROPERTY_TIMESTAMP_FORMAT, Collections.singletonList(this.timestampFormat.name()));
        if (this.retainFileCount != null) {
            props.put(PROPERTY_RETAIN_FILE_COUNT, Collections.singletonList(this.retainFileCount.longValue()));
        }
        if (this.retainFileAgeMillis != null) {
            props.put(PROPERTY_RETAIN_FILE_AGE_MILLIS, Collections.singletonList(this.retainFileAgeMillis));
        }
        if (this.retainAggregateFileSizeBytes != null) {
            props.put(PROPERTY_RETAIN_AGGREGATE_FILE_SIZE_BYTES, Collections.singletonList(this.retainAggregateFileSizeBytes));
        }
        return Collections.unmodifiableMap(props);
    }
}

