/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchEntryAccessLogMessage
extends SearchRequestAccessLogMessage {
    private static final long serialVersionUID = 6423635071693560277L;
    private final List<String> attributesReturned;
    private final List<String> responseControlOIDs;
    private final String dn = this.getNamedValue("dn");

    public SearchEntryAccessLogMessage(String s2) throws LogException {
        this(new LogMessage(s2));
    }

    public SearchEntryAccessLogMessage(LogMessage m3) {
        super(m3);
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        String attrs = this.getNamedValue("attrsReturned");
        if (attrs == null) {
            this.attributesReturned = null;
        } else {
            ArrayList<String> l = new ArrayList<String>(10);
            StringTokenizer tokenizer = new StringTokenizer(attrs, ",");
            while (tokenizer.hasMoreTokens()) {
                l.add(tokenizer.nextToken());
            }
            this.attributesReturned = Collections.unmodifiableList(l);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<String> getAttributesReturned() {
        return this.attributesReturned;
    }

    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY;
    }
}

