/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationResultAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class ModifyResultAccessLogMessage
extends ModifyRequestAccessLogMessage
implements OperationResultAccessLogMessage {
    private static final long serialVersionUID = -4950863829060893245L;
    private final AssuredReplicationLocalLevel assuredReplicationLocalLevel;
    private final AssuredReplicationRemoteLevel assuredReplicationRemoteLevel;
    private final Boolean responseDelayedByAssurance;
    private final Boolean changeToSoftDeletedEntry;
    private final Boolean uncachedDataAccessed;
    private final Double processingTime;
    private final Double queueTime;
    private final Integer targetPort;
    private final List<String> indexesWithKeysAccessedNearEntryLimit;
    private final List<String> indexesWithKeysAccessedOverEntryLimit;
    private final List<String> missingPrivileges;
    private final List<String> preAuthZUsedPrivileges;
    private final List<String> referralURLs;
    private final List<String> responseControlOIDs;
    private final List<String> serversAccessed;
    private final List<String> usedPrivileges;
    private final Long assuredReplicationTimeoutMillis;
    private final Long intermediateResponsesReturned;
    private final ResultCode resultCode;
    private final String additionalInformation;
    private final String authzDN;
    private final String diagnosticMessage = this.getNamedValue("message");
    private final String intermediateClientResult;
    private final String matchedDN;
    private final String replicationChangeID;
    private final String targetHost;
    private final String targetProtocol;

    public ModifyResultAccessLogMessage(String s2) throws LogException {
        this(new LogMessage(s2));
    }

    public ModifyResultAccessLogMessage(LogMessage m3) {
        super(m3);
        this.additionalInformation = this.getNamedValue("additionalInfo");
        this.matchedDN = this.getNamedValue("matchedDN");
        this.processingTime = this.getNamedValueAsDouble("etime");
        this.queueTime = this.getNamedValueAsDouble("qtime");
        this.intermediateClientResult = this.getNamedValue("from");
        this.authzDN = this.getNamedValue("authzDN");
        this.replicationChangeID = this.getNamedValue("replicationChangeID");
        this.targetHost = this.getNamedValue("targetHost");
        this.targetPort = this.getNamedValueAsInteger("targetPort");
        this.targetProtocol = this.getNamedValue("targetProtocol");
        this.changeToSoftDeletedEntry = this.getNamedValueAsBoolean("changeToSoftDeletedEntry");
        this.intermediateResponsesReturned = this.getNamedValueAsLong("intermediateResponsesReturned");
        Integer rcInteger = this.getNamedValueAsInteger("resultCode");
        this.resultCode = rcInteger == null ? null : ResultCode.valueOf(rcInteger);
        String refStr = this.getNamedValue("referralURLs");
        if (refStr == null || refStr.isEmpty()) {
            this.referralURLs = Collections.emptyList();
        } else {
            LinkedList<String> refs = new LinkedList<String>();
            int startPos = 0;
            while (true) {
                int commaPos;
                if ((commaPos = refStr.indexOf(",ldap", startPos)) < 0) break;
                refs.add(refStr.substring(startPos, commaPos));
                startPos = commaPos + 1;
            }
            refs.add(refStr.substring(startPos));
            this.referralURLs = Collections.unmodifiableList(refs);
        }
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        String serversAccessedStr = this.getNamedValue("serversAccessed");
        if (serversAccessedStr == null || serversAccessedStr.isEmpty()) {
            this.serversAccessed = Collections.emptyList();
        } else {
            LinkedList<String> servers = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(serversAccessedStr, ",");
            while (tokenizer.hasMoreTokens()) {
                servers.add(tokenizer.nextToken());
            }
            this.serversAccessed = Collections.unmodifiableList(servers);
        }
        this.uncachedDataAccessed = this.getNamedValueAsBoolean("uncachedDataAccessed");
        String localLevelStr = this.getNamedValue("localAssuranceLevel");
        this.assuredReplicationLocalLevel = localLevelStr == null ? null : AssuredReplicationLocalLevel.valueOf(localLevelStr);
        String remoteLevelStr = this.getNamedValue("remoteAssuranceLevel");
        this.assuredReplicationRemoteLevel = remoteLevelStr == null ? null : AssuredReplicationRemoteLevel.valueOf(remoteLevelStr);
        this.assuredReplicationTimeoutMillis = this.getNamedValueAsLong("assuranceTimeoutMillis");
        this.responseDelayedByAssurance = this.getNamedValueAsBoolean("responseDelayedByAssurance");
        String usedPrivilegesStr = this.getNamedValue("usedPrivileges");
        if (usedPrivilegesStr == null || usedPrivilegesStr.isEmpty()) {
            this.usedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(usedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.usedPrivileges = Collections.unmodifiableList(privileges);
        }
        String preAuthZUsedPrivilegesStr = this.getNamedValue("preAuthZUsedPrivileges");
        if (preAuthZUsedPrivilegesStr == null || preAuthZUsedPrivilegesStr.isEmpty()) {
            this.preAuthZUsedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(preAuthZUsedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.preAuthZUsedPrivileges = Collections.unmodifiableList(privileges);
        }
        String missingPrivilegesStr = this.getNamedValue("missingPrivileges");
        if (missingPrivilegesStr == null || missingPrivilegesStr.isEmpty()) {
            this.missingPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(missingPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.missingPrivileges = Collections.unmodifiableList(privileges);
        }
        String indexesNearLimitStr = this.getNamedValue("indexesWithKeysAccessedNearEntryLimit");
        if (indexesNearLimitStr == null || indexesNearLimitStr.isEmpty()) {
            this.indexesWithKeysAccessedNearEntryLimit = Collections.emptyList();
        } else {
            LinkedList<String> indexes = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(indexesNearLimitStr, ",");
            while (tokenizer.hasMoreTokens()) {
                indexes.add(tokenizer.nextToken());
            }
            this.indexesWithKeysAccessedNearEntryLimit = Collections.unmodifiableList(indexes);
        }
        String indexesOverLimitStr = this.getNamedValue("indexesWithKeysAccessedExceedingEntryLimit");
        if (indexesOverLimitStr == null || indexesOverLimitStr.isEmpty()) {
            this.indexesWithKeysAccessedOverEntryLimit = Collections.emptyList();
        } else {
            LinkedList<String> indexes = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(indexesOverLimitStr, ",");
            while (tokenizer.hasMoreTokens()) {
                indexes.add(tokenizer.nextToken());
            }
            this.indexesWithKeysAccessedOverEntryLimit = Collections.unmodifiableList(indexes);
        }
    }

    @Override
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    public String getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public Long getIntermediateResponsesReturned() {
        return this.intermediateResponsesReturned;
    }

    @Override
    public Double getProcessingTimeMillis() {
        return this.processingTime;
    }

    @Override
    public Double getQueueTimeMillis() {
        return this.queueTime;
    }

    @Override
    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    @Override
    public List<String> getServersAccessed() {
        return this.serversAccessed;
    }

    public Boolean getUncachedDataAccessed() {
        return this.uncachedDataAccessed;
    }

    @Override
    public String getIntermediateClientResult() {
        return this.intermediateClientResult;
    }

    public String getAlternateAuthorizationDN() {
        return this.authzDN;
    }

    public String getReplicationChangeID() {
        return this.replicationChangeID;
    }

    public Boolean getChangeToSoftDeletedEntry() {
        return this.changeToSoftDeletedEntry;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public Integer getTargetPort() {
        return this.targetPort;
    }

    public String getTargetProtocol() {
        return this.targetProtocol;
    }

    public AssuredReplicationLocalLevel getAssuredReplicationLocalLevel() {
        return this.assuredReplicationLocalLevel;
    }

    public AssuredReplicationRemoteLevel getAssuredReplicationRemoteLevel() {
        return this.assuredReplicationRemoteLevel;
    }

    public Long getAssuredReplicationTimeoutMillis() {
        return this.assuredReplicationTimeoutMillis;
    }

    public Boolean getResponseDelayedByAssurance() {
        return this.responseDelayedByAssurance;
    }

    public List<String> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    public List<String> getPreAuthorizationUsedPrivileges() {
        return this.preAuthZUsedPrivileges;
    }

    public List<String> getMissingPrivileges() {
        return this.missingPrivileges;
    }

    public List<String> getIndexesWithKeysAccessedNearEntryLimit() {
        return this.indexesWithKeysAccessedNearEntryLimit;
    }

    public List<String> getIndexesWithKeysAccessedOverEntryLimit() {
        return this.indexesWithKeysAccessedOverEntryLimit;
    }

    @Override
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }
}

