/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LogMessage
implements Serializable {
    private static final String TIMESTAMP_SEC_FORMAT = "'['dd/MMM/yyyy:HH:mm:ss Z']'";
    private static final String TIMESTAMP_MS_FORMAT = "'['dd/MMM/yyyy:HH:mm:ss.SSS Z']'";
    private static final ThreadLocal<SimpleDateFormat> dateSecFormat = new ThreadLocal();
    private static final ThreadLocal<SimpleDateFormat> dateMsFormat = new ThreadLocal();
    private static final long serialVersionUID = -1210050773534504972L;
    private final Date timestamp;
    private final Map<String, String> namedValues;
    private final Set<String> unnamedValues;
    private final String messageString;

    protected LogMessage(LogMessage m3) {
        this.timestamp = m3.timestamp;
        this.unnamedValues = m3.unnamedValues;
        this.namedValues = m3.namedValues;
        this.messageString = m3.messageString;
    }

    protected LogMessage(String s2) throws LogException {
        SimpleDateFormat f;
        this.messageString = s2;
        int bracketPos = s2.indexOf(93);
        if (bracketPos < 0) {
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_NO_TIMESTAMP.get());
        }
        String timestampString = s2.substring(0, bracketPos + 1);
        if (LogMessage.timestampIncludesMilliseconds(timestampString)) {
            f = dateMsFormat.get();
            if (f == null) {
                f = new SimpleDateFormat(TIMESTAMP_MS_FORMAT);
                f.setLenient(false);
                dateMsFormat.set(f);
            }
        } else {
            f = dateSecFormat.get();
            if (f == null) {
                f = new SimpleDateFormat(TIMESTAMP_SEC_FORMAT);
                f.setLenient(false);
                dateSecFormat.set(f);
            }
        }
        try {
            this.timestamp = f.parse(timestampString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_TIMESTAMP.get(StaticUtils.getExceptionMessage(e)), e);
        }
        LinkedHashMap<String, String> named = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(10));
        LinkedHashSet<String> unnamed = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        LogMessage.parseTokens(s2, bracketPos + 1, named, unnamed);
        this.namedValues = Collections.unmodifiableMap(named);
        this.unnamedValues = Collections.unmodifiableSet(unnamed);
    }

    private static void parseTokens(String s2, int startPos, Map<String, String> named, Set<String> unnamed) throws LogException {
        boolean inQuotes = false;
        StringBuilder buffer = new StringBuilder();
        for (int p = startPos; p < s2.length(); ++p) {
            char c = s2.charAt(p);
            if (c == ' ' && !inQuotes) {
                if (buffer.length() <= 0) continue;
                LogMessage.processToken(s2, buffer.toString(), named, unnamed);
                buffer.delete(0, buffer.length());
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            LogMessage.processToken(s2, buffer.toString(), named, unnamed);
        }
    }

    private static void processToken(String s2, String token, Map<String, String> named, Set<String> unnamed) throws LogException {
        int equalPos = token.indexOf(61);
        if (equalPos < 0) {
            unnamed.add(token);
        } else {
            String name = token.substring(0, equalPos);
            String value = LogMessage.processValue(s2, token.substring(equalPos + 1));
            named.put(name, value);
        }
    }

    private static String processValue(String s2, String v) throws LogException {
        ByteStringBuffer b = new ByteStringBuffer();
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c == '\"') continue;
            if (c == '#') {
                if (i > v.length() - 3) {
                    throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER.get(v));
                }
                byte rawByte = 0;
                block19: for (int j = 0; j < 2; ++j) {
                    rawByte = (byte)(rawByte << 4);
                    switch (v.charAt(++i)) {
                        case '0': {
                            continue block19;
                        }
                        case '1': {
                            rawByte = (byte)(rawByte | 1);
                            continue block19;
                        }
                        case '2': {
                            rawByte = (byte)(rawByte | 2);
                            continue block19;
                        }
                        case '3': {
                            rawByte = (byte)(rawByte | 3);
                            continue block19;
                        }
                        case '4': {
                            rawByte = (byte)(rawByte | 4);
                            continue block19;
                        }
                        case '5': {
                            rawByte = (byte)(rawByte | 5);
                            continue block19;
                        }
                        case '6': {
                            rawByte = (byte)(rawByte | 6);
                            continue block19;
                        }
                        case '7': {
                            rawByte = (byte)(rawByte | 7);
                            continue block19;
                        }
                        case '8': {
                            rawByte = (byte)(rawByte | 8);
                            continue block19;
                        }
                        case '9': {
                            rawByte = (byte)(rawByte | 9);
                            continue block19;
                        }
                        case 'A': 
                        case 'a': {
                            rawByte = (byte)(rawByte | 0xA);
                            continue block19;
                        }
                        case 'B': 
                        case 'b': {
                            rawByte = (byte)(rawByte | 0xB);
                            continue block19;
                        }
                        case 'C': 
                        case 'c': {
                            rawByte = (byte)(rawByte | 0xC);
                            continue block19;
                        }
                        case 'D': 
                        case 'd': {
                            rawByte = (byte)(rawByte | 0xD);
                            continue block19;
                        }
                        case 'E': 
                        case 'e': {
                            rawByte = (byte)(rawByte | 0xE);
                            continue block19;
                        }
                        case 'F': 
                        case 'f': {
                            rawByte = (byte)(rawByte | 0xF);
                            continue block19;
                        }
                        default: {
                            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER.get(v));
                        }
                    }
                }
                b.append(rawByte);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static boolean timestampIncludesMilliseconds(String timestamp) {
        return timestamp.length() > 21 && timestamp.charAt(21) == '.';
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    public final Map<String, String> getNamedValues() {
        return this.namedValues;
    }

    public final String getNamedValue(String name) {
        return this.namedValues.get(name);
    }

    public final Boolean getNamedValueAsBoolean(String name) {
        String s2 = this.namedValues.get(name);
        if (s2 == null) {
            return null;
        }
        String lowerValue = StaticUtils.toLowerCase(s2);
        if (lowerValue.equals("true") || lowerValue.equals("t") || lowerValue.equals("yes") || lowerValue.equals("y") || lowerValue.equals("on") || lowerValue.equals("1")) {
            return Boolean.TRUE;
        }
        if (lowerValue.equals("false") || lowerValue.equals("f") || lowerValue.equals("no") || lowerValue.equals("n") || lowerValue.equals("off") || lowerValue.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public final Double getNamedValueAsDouble(String name) {
        String s2 = this.namedValues.get(name);
        if (s2 == null) {
            return null;
        }
        try {
            return Double.valueOf(s2);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public final Integer getNamedValueAsInteger(String name) {
        String s2 = this.namedValues.get(name);
        if (s2 == null) {
            return null;
        }
        try {
            return Integer.valueOf(s2);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public final Long getNamedValueAsLong(String name) {
        String s2 = this.namedValues.get(name);
        if (s2 == null) {
            return null;
        }
        try {
            return Long.valueOf(s2);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    public final Set<String> getUnnamedValues() {
        return this.unnamedValues;
    }

    public final boolean hasUnnamedValue(String value) {
        return this.unnamedValues.contains(value);
    }

    public final String toString() {
        return this.messageString;
    }
}

