/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AbandonForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AbandonResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.AddAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ClientCertificateAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DisconnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.EntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.EntryRebalancingResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.IntermediateResponseAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchEntryAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchReferenceAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SecurityNegotiationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.UnbindRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AccessLogReader
implements Closeable {
    private final BufferedReader reader;

    public AccessLogReader(String path) throws IOException {
        this.reader = new BufferedReader(new FileReader(path));
    }

    public AccessLogReader(File file) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
    }

    public AccessLogReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public AccessLogMessage read() throws IOException, LogException {
        String line;
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return null;
        } while (line.isEmpty() || line.charAt(0) == '#');
        return AccessLogReader.parse(line);
    }

    public static AccessLogMessage parse(String s2) throws LogException {
        LogMessage m3 = new LogMessage(s2);
        if (m3.hasUnnamedValue(AccessLogMessageType.CONNECT.getLogIdentifier())) {
            return new ConnectAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.DISCONNECT.getLogIdentifier())) {
            return new DisconnectAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.CLIENT_CERTIFICATE.getLogIdentifier())) {
            return new ClientCertificateAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.SECURITY_NEGOTIATION.getLogIdentifier())) {
            return new SecurityNegotiationAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.ENTRY_REBALANCING_REQUEST.getLogIdentifier())) {
            return new EntryRebalancingRequestAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.ENTRY_REBALANCING_RESULT.getLogIdentifier())) {
            return new EntryRebalancingResultAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.REQUEST.getLogIdentifier())) {
            if (m3.hasUnnamedValue(AccessLogOperationType.ABANDON.getLogIdentifier())) {
                return new AbandonRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchRequestAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.UNBIND.getLogIdentifier())) {
                return new UnbindRequestAccessLogMessage(m3);
            }
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_REQUEST_OPERATION_TYPE.get());
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.RESULT.getLogIdentifier())) {
            if (m3.hasUnnamedValue(AccessLogOperationType.ABANDON.getLogIdentifier())) {
                return new AbandonResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNResultAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchResultAccessLogMessage(m3);
            }
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_RESULT_OPERATION_TYPE.get());
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.FORWARD.getLogIdentifier())) {
            if (m3.hasUnnamedValue(AccessLogOperationType.ABANDON.getLogIdentifier())) {
                return new AbandonForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNForwardAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchForwardAccessLogMessage(m3);
            }
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_FORWARD_OPERATION_TYPE.get());
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.FORWARD_FAILED.getLogIdentifier())) {
            if (m3.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNForwardFailedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchForwardFailedAccessLogMessage(m3);
            }
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_FORWARD_FAILED_OPERATION_TYPE.get());
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.ASSURANCE_COMPLETE.getLogIdentifier())) {
            if (m3.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddAssuranceCompletedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteAssuranceCompletedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyAssuranceCompletedAccessLogMessage(m3);
            }
            if (m3.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNAssuranceCompletedAccessLogMessage(m3);
            }
            throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_ASSURANCE_COMPLETE_OPERATION_TYPE.get());
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.ENTRY.getLogIdentifier())) {
            return new SearchEntryAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.REFERENCE.getLogIdentifier())) {
            return new SearchReferenceAccessLogMessage(m3);
        }
        if (m3.hasUnnamedValue(AccessLogMessageType.INTERMEDIATE_RESPONSE.getLogIdentifier())) {
            return new IntermediateResponseAccessLogMessage(m3);
        }
        throw new LogException(s2, LogMessages.ERR_LOG_MESSAGE_INVALID_ACCESS_MESSAGE_TYPE.get());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

