/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.MinimalOperationResultAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AbandonResultAccessLogMessage
extends AbandonRequestAccessLogMessage
implements MinimalOperationResultAccessLogMessage {
    private static final long serialVersionUID = 6714469240483228080L;
    private final Boolean uncachedDataAccessed;
    private final Double processingTime;
    private final Double queueTime;
    private final List<String> missingPrivileges;
    private final List<String> preAuthZUsedPrivileges;
    private final List<String> referralURLs;
    private final List<String> responseControlOIDs;
    private final List<String> serversAccessed;
    private final List<String> usedPrivileges;
    private final ResultCode resultCode;
    private final String additionalInformation;
    private final String diagnosticMessage = this.getNamedValue("message");
    private final String intermediateClientResult;
    private final String matchedDN;
    private final Integer targetPort;
    private final String targetHost;
    private final String targetProtocol;

    public AbandonResultAccessLogMessage(String s2) throws LogException {
        this(new LogMessage(s2));
    }

    public AbandonResultAccessLogMessage(LogMessage m3) {
        super(m3);
        this.additionalInformation = this.getNamedValue("additionalInfo");
        this.matchedDN = this.getNamedValue("matchedDN");
        this.processingTime = this.getNamedValueAsDouble("etime");
        this.queueTime = this.getNamedValueAsDouble("qtime");
        this.intermediateClientResult = this.getNamedValue("from");
        this.targetHost = this.getNamedValue("targetHost");
        this.targetPort = this.getNamedValueAsInteger("targetPort");
        this.targetProtocol = this.getNamedValue("targetProtocol");
        Integer rcInteger = this.getNamedValueAsInteger("resultCode");
        this.resultCode = rcInteger == null ? null : ResultCode.valueOf(rcInteger);
        String refStr = this.getNamedValue("referralURLs");
        if (refStr == null || refStr.isEmpty()) {
            this.referralURLs = Collections.emptyList();
        } else {
            LinkedList<String> refs = new LinkedList<String>();
            int startPos = 0;
            while (true) {
                int commaPos;
                if ((commaPos = refStr.indexOf(",ldap", startPos)) < 0) break;
                refs.add(refStr.substring(startPos, commaPos));
                startPos = commaPos + 1;
            }
            refs.add(refStr.substring(startPos));
            this.referralURLs = Collections.unmodifiableList(refs);
        }
        String controlStr = this.getNamedValue("responseControls");
        if (controlStr == null) {
            this.responseControlOIDs = Collections.emptyList();
        } else {
            LinkedList<String> controlList = new LinkedList<String>();
            StringTokenizer t = new StringTokenizer(controlStr, ",");
            while (t.hasMoreTokens()) {
                controlList.add(t.nextToken());
            }
            this.responseControlOIDs = Collections.unmodifiableList(controlList);
        }
        String serversAccessedStr = this.getNamedValue("serversAccessed");
        if (serversAccessedStr == null || serversAccessedStr.isEmpty()) {
            this.serversAccessed = Collections.emptyList();
        } else {
            LinkedList<String> servers = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(serversAccessedStr, ",");
            while (tokenizer.hasMoreTokens()) {
                servers.add(tokenizer.nextToken());
            }
            this.serversAccessed = Collections.unmodifiableList(servers);
        }
        this.uncachedDataAccessed = this.getNamedValueAsBoolean("uncachedDataAccessed");
        String usedPrivilegesStr = this.getNamedValue("usedPrivileges");
        if (usedPrivilegesStr == null || usedPrivilegesStr.isEmpty()) {
            this.usedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(usedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.usedPrivileges = Collections.unmodifiableList(privileges);
        }
        String preAuthZUsedPrivilegesStr = this.getNamedValue("preAuthZUsedPrivileges");
        if (preAuthZUsedPrivilegesStr == null || preAuthZUsedPrivilegesStr.isEmpty()) {
            this.preAuthZUsedPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(preAuthZUsedPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.preAuthZUsedPrivileges = Collections.unmodifiableList(privileges);
        }
        String missingPrivilegesStr = this.getNamedValue("missingPrivileges");
        if (missingPrivilegesStr == null || missingPrivilegesStr.isEmpty()) {
            this.missingPrivileges = Collections.emptyList();
        } else {
            LinkedList<String> privileges = new LinkedList<String>();
            StringTokenizer tokenizer = new StringTokenizer(missingPrivilegesStr, ",");
            while (tokenizer.hasMoreTokens()) {
                privileges.add(tokenizer.nextToken());
            }
            this.missingPrivileges = Collections.unmodifiableList(privileges);
        }
    }

    @Override
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    public String getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public Double getProcessingTimeMillis() {
        return this.processingTime;
    }

    @Override
    public Double getQueueTimeMillis() {
        return this.queueTime;
    }

    public List<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }

    public List<String> getServersAccessed() {
        return this.serversAccessed;
    }

    public Boolean getUncachedDataAccessed() {
        return this.uncachedDataAccessed;
    }

    public String getIntermediateClientResult() {
        return this.intermediateClientResult;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    public Integer getTargetPort() {
        return this.targetPort;
    }

    public String getTargetProtocol() {
        return this.targetProtocol;
    }

    public List<String> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    public List<String> getPreAuthorizationUsedPrivileges() {
        return this.preAuthZUsedPrivileges;
    }

    public List<String> getMissingPrivileges() {
        return this.missingPrivileges;
    }

    @Override
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }
}

